import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Rectangle{
    id: ltsRoot

    anchors.fill: parent

    color: ViaviStyle.colors.pageBackgroundColor

    readonly property real scaleFactor: ViaviStyle.layout.isSmallScreen ? 0.7 : 1
    /* TODO - find an efficient way to load this popup only when needed */
    NumericDisplayDwdmWavelengthSelection {
        id: numericDisplayDwdmWavelengthSelection
    }

    ColumnLayout{
        anchors.fill: parent
        anchors.leftMargin : ViaviStyle.layout.largeMargin
        anchors.rightMargin : ViaviStyle.layout.largeMargin
        anchors.topMargin : ViaviStyle.layout.mediumMargin * ltsRoot.scaleFactor
        anchors.bottomMargin : ViaviStyle.layout.mediumMargin * ltsRoot.scaleFactor

        spacing: ViaviStyle.layout.largeMargin * ltsRoot.scaleFactor

        NumericDisplay {
            id: sourceNumericDisplay
            infoType: 'Source'
            visible: status_res_sourceNumericEnabled.value
            Layout.fillWidth: true
        }

        ColumnLayout {
            id: powermeterLayout
            spacing: 0
            NumericDisplay {
                id: powermeterNumericDisplay
                infoType: 'Powermeter'
                visible: status_res_powermeterNumericEnabled.value
                Layout.fillWidth: true
            }

            GenericTable {
                id: table
                Layout.fillWidth: true
                Layout.fillHeight: true
                visible: status_res_powermeterNumericEnabled.value

                ImageButton {
                    anchors.right : parent.right
                    anchors.rightMargin: ViaviStyle.layout.smallMargin

                    y: (table.titleAreaHeight - height) / 2

                    source: FiberStyle.images.deleteIcon
                    visible: numericdisplay_res_powermeterClearTableEnabled.value
                    onClicked:{
                        numericdisplay_act_powermeterClearTable.invoke()
                    }
                }
            }
        }
    }
}
