import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: container

    width: 600
    height: 250

    color: VColor.cViaviColorLightGray2
    
    border.color: VColor.cViaviColorGray
    border.width: 4
    
    property int standardHeight: 40

    property int indexTestPlan: -1
    property int containerTextSize: 12
    
    property string inputHeadertext: ""
    property string inputLowerText: ""
    property string inputAutoHeadertext: ""
    property string inputPersonnalHeaderText: ""
    property alias inputModel: repeaterItem.model
    
    property int indexAlarm: -1

    property string personnalComment: ""
    property string autoComment: ""
    property int currentCode: -1
    property bool bDisplayList: false

    function close( validation ) {
        container.visible = false;
        container.autoComment = "";
        container.personnalComment = "";
        container.indexTestPlan = -1;
        container.currentCode = -1;
        container.bDisplayList = false;
    }
    
    Text {
      id: textHeader
      
      anchors.left: container.left
      anchors.leftMargin: 10
      anchors.top: container.top
      anchors.topMargin: 10
      
      text: container.inputHeadertext
      
      font.bold: true
      font.pointSize: 16
      font.family: "DejaVu LGC Sans"
    }
    
    Column {
    	anchors.top: textHeader.bottom
    	anchors.topMargin: 5
    	
    	anchors.bottom: buttonSelection.top
    	anchors.bottomMargin: 5
    	
    	anchors.left: container.left
    	anchors.leftMargin: 20
    	
    	spacing: 5
    	
		Repeater {
			id: repeaterItem
		    
		    Rectangle {
		        width: 150
		        height: standardHeight
		        color: "transparent"
		        
		        Rectangle {
		            id: checkIcon
		        	anchors.left: parent.left
		        	anchors.verticalCenter: parent.verticalCenter
		        	
		        	width: parent.height - 6
		        	height: width
		        	
		        	radius: width * 0.5
		        	
		        	color: indexAlarm == index ? VColor.cViaviColorLogoPurple : "transparent"
		        	border.color: VColor.cViaviColorLogoPurple
		        	border.width: 4
		        }
		        
		        Text {
		        	anchors.left: checkIcon.right
		        	anchors.leftMargin: 10
		        	anchors.verticalCenter: parent.verticalCenter
		        	text: modelData
		        	font.pixelSize: 16
		        }
		        
		        MouseArea {
		        	anchors.fill: parent
		        	onClicked: {
		        		container.indexAlarm = index;
		        	}
		        }
		    }
		}
    }
    
    Text {
      anchors.left: personnalCommentContainer.left
      anchors.bottom: personnalCommentContainer.top
      anchors.bottomMargin: 5

      text: container.inputPersonnalHeaderText

      font.italic: true
      font.pointSize: 12
      font.family: "DejaVu LGC Sans"
    }

    Rectangle {
      id: personnalCommentContainer

      anchors.right: container.right
      anchors.rightMargin: 10
      anchors.top: isPredefinedComment() ? autoCommentContainer.bottom : textHeader.bottom
      anchors.topMargin: isPredefinedComment() ? 30 : 20


      height: container.standardHeight
      width: container.width * 0.5

      clip: true

      function editText(txtOutput, validation) {
         if (validation === true)
            {
            container.personnalComment = txtOutput;
            }
            keyboard.editText.disconnect( personnalCommentContainer.editText );
      }

      Text {
          anchors.left: parent.left
          anchors.leftMargin: 3
          anchors.verticalCenter: parent.verticalCenter

          text: container.personnalComment
          font.family: "DejaVu LGC Sans"
          font.pointSize: containerTextSize
      }

      MouseArea {
         anchors.fill: parent

         onClicked: {
            keyboard.editText.connect( personnalCommentContainer.editText );
            openKeyBoard( container.inputPersonnalHeaderText, container.personnalComment );
         }
      }
    }


    Text {
      anchors.left: autoCommentContainer.left
      anchors.bottom: autoCommentContainer.top
      anchors.bottomMargin: 5

      text: isPredefinedComment() ? container.inputAutoHeadertext:""

      font.italic: true
      font.pointSize: 12
      font.family: "DejaVu LGC Sans"
    }

    Rectangle {
      id: autoCommentContainer

      visible : isPredefinedComment()

      height: standardHeight
      width: container.width * 0.5
      anchors.right: container.right
      anchors.rightMargin: 10
      anchors.top: isPredefinedComment() ? textHeader.bottom :  personnalCommentContainer.bottom
      anchors.topMargin:20

      clip: true

      Text {
          anchors.verticalCenter: parent.verticalCenter
          anchors.left: parent.left
          anchors.leftMargin: 3
          font.pointSize: containerTextSize
          text: container.autoComment
          font.family: "DejaVu LGC Sans"
      }
    }

    Rectangle {
      id: containerListView

      visible : container.bDisplayList

      anchors.left: autoCommentContainer.left
      anchors.right: autoCommentContainer.right
      anchors.top: autoCommentContainer.bottom
      anchors.topMargin: 2
      anchors.bottom: buttonSelection.top
      anchors.bottomMargin: 2

      color: "white"

      ListView {
          id: listAutoComment

          anchors.fill: parent
          anchors.margins: 2
          boundsBehavior: Flickable.StopAtBounds
          spacing: 2
          clip: true

          model: Job_Mgr.autoCommentsModel

          delegate: Rectangle {
                  width: parent.width
                  height: 20
                  color: index === container.currentCode ? VColor.cViaviColorLogoPurple : "transparent"

                  Text {
                      anchors.fill: parent
                      anchors.leftMargin: 5
                      verticalAlignment: Text.AlignVCenter
                      text: modelData
                      font.family: "DejaVu LGC SansCondensed"
                      font.pointSize: containerTextSize
                      color: index === container.currentCode ? VColor.cViaviColorWhite : VColor.cViaviRealBlack
                  }

                  MouseArea {
                      anchors.fill: parent

                      onClicked: {
                          container.currentCode = index;
                          container.autoComment = modelData;
                          container.bDisplayList = false;
                      }
                  }
              }
         }
    }

    Rectangle {
      id: displayListButton

      visible : isPredefinedComment()

      width: height
      height: standardHeight
      anchors.right: autoCommentContainer.left
      anchors.verticalCenter: autoCommentContainer.verticalCenter
      color: VColor.cViaviColorGray

      clip: true

      Image {
         anchors.centerIn: parent
         source: container.bDisplayList ? "/acterna/storage/look-and-feel/generic/Open_32.png" : "/acterna/storage/look-and-feel/generic/Close_32.png"

         fillMode: Image.PreserveAspectFit
      }

      MouseArea {
          anchors.fill: parent

          onClicked: {
              container.bDisplayList = !container.bDisplayList;
          }
      }
    }
    
    Rectangle {
       id: buttonSelection
       
       height: 50 //container.standardHeight * 1.5
       
       property int buttonWidth: buttonSelection.height * 1.5
       property int buttonHeight: buttonSelection.height
       property int buttonMargin: 10

       color: VColor.cViaviColorLightGray2
       
       anchors.bottom: container.bottom
       anchors.left: container.left
       anchors.right: container.right
       
       Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: rowButtons.left
         anchors.rightMargin: 2

         color: VColor.cViaviColorGray
       
         Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: container.inputLowerText
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pointSize: 16
            wrapMode: Text.NoWrap
            
            clip: true
         }
       }

       Row {
         id: rowButtons
         spacing: 2
         
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.right: parent.right
         
         layoutDirection: Qt.RightToLeft
   
         Rectangle {
               id:validbutton
         
               color: VColor.cViaviColorGray
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
               
               opacity: indexAlarm !== (-1) ? 1 : 0.6
         
               Image {
                   id: imgValidButton
                   fillMode: Image.PreserveAspectFit
                   
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Ok.png"
               }
         
         
               MouseArea {
                   id: mouseAreaValidButton
                   anchors.fill: parent
                   
                   enabled: indexAlarm !== (-1)
                   
                   onClicked: {
                     container.close( true );
                   }
               }
         
               states: State {
                   name: "pressed"
                   when: mouseAreaValidButton.pressed
                   PropertyChanges {
                       target: validbutton
                       color: VColor.cViaviColorLightBlue
                   }
               }
         }
   
         Rectangle {
               id:cancelbutton
   
               color: VColor.cViaviColorGray
   
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
   
               Image {
                   id: imgCancelButton
                   
                   fillMode: Image.PreserveAspectFit
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Clear.png"
               }
   
               MouseArea {
                   id: mouseAreaCancelButton
                   anchors.fill: parent
                   
                   onClicked: {
                     container.close( false );
                   }
               }
   
               states: State {
                   name: "pressed"
                   when: mouseAreaCancelButton.pressed
                   PropertyChanges {
                       target: cancelbutton
                       color: VColor.cViaviColorLightBlue
                   }
               }
         }
       }
    }
function isPredefinedComment(){
    return (Job_Mgr.testPlanModel.predefinedCommentState === true)
}
}


