import QtQuick 2.12
import QtQml 2.12
import QtQuick.Controls 2.2

import "Viavi_Colors.js" as VColor
import libjobmgr 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: backgroundJobMgr

    property bool ijmIsDisplayed: true

    color: VColor.cViaviRealBlack
    focus: true

    JobManagerTranslation {
      id: jobManagerTranslation
      
      Component.onCompleted: {
         // Update connection
         Job_Mgr.updateAllTraduction.connect( jobManagerTranslation.traductionChanged )
      }
    }

    Popup {
        id : ijmJobManager
        anchors.centerIn: parent
        width: backgroundJobMgr.width
        height: backgroundJobMgr.height
        closePolicy: Popup.NoAutoClose
        modal: false
        focus: true
        visible: ( ijmIsDisplayed ) ? 1 : 0
        opacity: ( ijmIsDisplayed ) ? 1 : 0

        DefaultLayout { // Imported from IJM GUI
            id: defaultLayout
            anchors.fill:parent
            clip:true
            showHeader: false
            showNewButton: true
            showMoreOptions: false
            keyboardHeightScale: 0.5
            pauseAutomaticUpdates: !Job_Mgr.jobManagerWidgetVisible

            onSyncRequested: { // signal from IJM GUI
                console.log("[Qml] Sync button was pressed" );
                Job_Mgr.buttonStrataSync(); // Use same slot as Legacy Job Mgr for now
            }

            onCreateReportClicked: { // signal from IJM GUI
                console.log("[Qml] Create Report button was pressed" );
                Job_Mgr.buttonCreateSummaryReport(job.jobNumber);  // Use same slot as Legacy Job Mgr for now
            }

            jobPropertyDisplayNames: ({  // Allows us to provide translations we already have available
                "customerName": jobManagerTranslation.txtIjmCustomer, 
                "jobNumber": jobManagerTranslation.txtIjmJobId,
                "techId": jobManagerTranslation.txtIjmTechId,
                "contractorId": jobManagerTranslation.txtIjmContractorId,
                "cableId": jobManagerTranslation.txtIjmCableId,
                "cableIdAtB": jobManagerTranslation.txtIjmCableIdExt,
                "fiberId": jobManagerTranslation.txtIjmFiberId,
                "fiberIdAtB": jobManagerTranslation.txtIjmFiberIdExt,
                "fiberNumber": jobManagerTranslation.txtIjmFiberNumber,
                "fiberNumberAtB": jobManagerTranslation.txtIjmFiberNumberExt,
                "testLocationA": jobManagerTranslation.txtIjmLocA,
                "testLocationB": jobManagerTranslation.txtIjmLocB
                // (and possibly...) jobManagerTranslation.txtIjmComments // mComments
                })

            preferredTestProperties: ["configuration"] // Use the configuration column to display refInfo correctly // Exclude ,"location"]
            preferredTestPropertiesAlwaysVisible: 1    // Just one column is enough
            testPropertyDisplayNames: ({
                "configuration": jobManagerTranslation.txtIjmConfColumnTitle, 
                "location": jobManagerTranslation.txtIjmLocColumnTitle,
                "fiberId": jobManagerTranslation.txtIjmFiberId,       // TODO TODO Allow this to be used in IJM qml
                "fiberIdAtB": jobManagerTranslation.txtIjmFiberIdExt, // TODO Allow this to be used in IJM qml
                "fiberNumber": jobManagerTranslation.txtIjmFiberNumber,       // TODO Allow this to be used in IJM qml
                "fiberNumberAtB": jobManagerTranslation.txtIjmFiberNumberExt,  // TODO Allow this to be used in IJM qml
                "connectorId": jobManagerTranslation.txtIjmConnectorId, // TODO Allow this to be used in IJM qml
                "connectorIdAtB": jobManagerTranslation.txtIjmConnectorIdExt, // TODO Allow this to be used in IJM qml
                // + Config file translation?
                })

            fileDialogFolders: ([ // Used for pop-up dialogs when importing label lists into IJM ISW-2423
                {
                "name": "disk",
                "path": "/user/disk",
                "icon": "/acterna/storage/look-and-feel/generic/harddrive.png"
                },
                {
                "name": "usb",
                "path": "/user/usbflash",
                "icon": "/acterna/storage/look-and-feel/generic/usbflash.png"
                }
            ])
        }
    }
} // end Rectangle
