import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.fiberutilui 1.0

Rectangle{
    id: functionsTabsContainer

    height: ViaviStyle.layout.isSmallScreen ?
                ViaviStyle.layout.buttonHeight / 2 : ViaviStyle.layout.buttonHeight

    color: ViaviStyle.colors.contentBackgroundColor

    function translateIconTypeToPath(type){
        switch(type){
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Default:
                return FiberStyle.images.tabsIconsBasePath + "fn_default.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Otdr:
                return FiberStyle.images.tabsIconsBasePath + "fn_otdr.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Osa:
                return FiberStyle.images.tabsIconsBasePath + "fn_osa.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pmd:
                return FiberStyle.images.tabsIconsBasePath + "fn_pmd.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pwrmtr:
                return FiberStyle.images.tabsIconsBasePath + "fn_pwrmtr.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Switch:
                return FiberStyle.images.tabsIconsBasePath + "fn_switch.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Fix:
                return FiberStyle.images.tabsIconsBasePath + "fn_fix.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Ovp:
                return FiberStyle.images.tabsIconsBasePath + "fn_ovp.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Oeo:
                return FiberStyle.images.tabsIconsBasePath + "fn_oeo.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Ats:
                return FiberStyle.images.tabsIconsBasePath + "fn_ats.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Orl:
                return FiberStyle.images.tabsIconsBasePath + "fn_orl.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Bbs:
                return FiberStyle.images.tabsIconsBasePath + "fn_bbs.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Odm:
                return FiberStyle.images.tabsIconsBasePath + "fn_odm.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pib:
                return FiberStyle.images.tabsIconsBasePath + "fn_pib.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Jfk:
                return FiberStyle.images.tabsIconsBasePath + "fn_jfk.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Dts:
                return FiberStyle.images.tabsIconsBasePath + "fn_dts.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Dtss:
                return FiberStyle.images.tabsIconsBasePath + "fn_dtss.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Unknown:
                return "";
        }
        return "";
    }

    ListView{
        id: listViewId
        anchors.fill: parent

        orientation: ListView.Horizontal
        boundsBehavior: Flickable.OvershootBounds

        model: functionsTabs_res_functions.value

        readonly property int maxNrOfVisibleItems: 6
        property int cellWidth: width / maxNrOfVisibleItems

        delegate: Item{
            id: rootDelegate

            readonly property real scaleFactor: ViaviStyle.layout.isSmallScreen ? 1.4 : 2

            width: Math.max(listViewId.cellWidth, laser.width + functionImage.width + functionText.width + ViaviStyle.layout.largeMargin)
            height: functionsTabsContainer.height
            clip: true

            Rectangle{
                id: backgroundRectangle
                anchors.fill: parent

                color: mouseAreaId.pressed
                       ?  ViaviStyle.colors.selectedColor
                       : (model.index === functionsTabs_cfg_currentFunction.value)
                                        ? ViaviStyle.colors.activeColor : "transparent"

                border.color: ViaviStyle.colors.borderColor
            }

            Row{
                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.left: parent.left

                anchors.margins: ViaviStyle.layout.smallMargin

                spacing: ViaviStyle.layout.smallMargin

                Item{
                    id: laser

                    width: rootDelegate.height / 4
                    height: width
                    anchors.verticalCenter: parent.verticalCenter

                    Rectangle{
                        anchors.fill: parent

                        radius: width / 2

                        color: measurementRunning ? ViaviStyle.colors.passColor : "transparent"
                        border.color: ViaviStyle.colors.separatorColor

                        visible: model.functionRunning || model.measurementRunning
                    }
                }


                Image {
                    id: functionImage
                    anchors.verticalCenter: parent.verticalCenter

                    height: functionText.contentHeight
                    width: height * rootDelegate.scaleFactor

                    source: translateIconTypeToPath(model.icon)
                }

                Text{
                    id: functionText
                    verticalAlignment: Text.AlignVCenter
                    anchors.verticalCenter: parent.verticalCenter

                    text: model.name
                    font: ViaviStyle.layout.activeTextFont
                    color: (mouseAreaId.pressed
                            || model.index === functionsTabs_cfg_currentFunction.value )
                                ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
                }
            }

            MouseArea{
                id: mouseAreaId

                anchors.fill: parent

                onClicked: {
                    functionsTabs_cfg_currentFunction.value = model.index
                }
            }

        }
    }
}
