﻿import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui 1.0

BasicContainer{
    id: synopticRoot

    readonly property int statusPictureSize: 50
    
    property bool bLoopbackDisplay: synoptic_res_linkState.value == synoptic_res_linkState.enums.elsLoopback_AB || synoptic_res_linkState.value == synoptic_res_linkState.enums.elsLoopback_BA

    /* Show/hide the test component */
    property bool testModuleVisible: false
    /* button for showing the test component */

    property int deviceMargin: parent.width / 16
    Button {
        visible: synoptic_res_testModuleEnabled.value

        anchors.bottom: parent.bottom
        anchors.left: parent.left

        text: "Show Test"
        width: 90
        height: 40
        onClicked: testModuleVisible = !testModuleVisible
    }

    /* central item to hold everything toghether*/
    Item {
        id: contentItem

        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layout.mediumMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin + ViaviStyle.layout.genericTableLineHeight
        anchors.left: parent.left
        anchors.leftMargin: 10 * ViaviStyle.layout.mediumMargin
        anchors.right: parent.right
        anchors.rightMargin: 10 * ViaviStyle.layout.mediumMargin

        /* laser image and text */
        Image {
            id: localLaser
            anchors.horizontalCenter: parent.left
            anchors.verticalCenter: parent.verticalCenter

            width: statusPictureSize
            height: statusPictureSize

            source: FiberStyle.images.fixLaserImage
            fillMode: Image.PreserveAspectFit

            visible: synoptic_res_localLaserEnabled.value

            Text {
                anchors.top: localLaser.bottom
                anchors.horizontalCenter: localLaser.horizontalCenter

                text: synoptic_res_localLaser.value
                font: ViaviStyle.layout.mediumBoldFont
                color: ViaviStyle.colors.mainInfoColor
            }
        }

        /* local device */
        FixDevice {
            id: localDeviceImg

            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.leftMargin: deviceMargin

            deviceState: synoptic_res_localDeviceState
            deviceType: synoptic_cfg_localDeviceType
            functionState: synoptic_res_localFunctionState
            connectorYOffset: ViaviStyle.layout.fixLocalDeviceConnectorOffset //didn't manage to put inside the device. the states and binding don't work exactly as expected

            opacity: localDeviceButton.pressed ? 0.7 : 1
            MouseArea {
                id: localDeviceButton
                anchors.fill: parent
                onClicked: synoptic_act_localDeviceAction.invoke()
            }
        }

        Text {
            anchors.bottom: localDeviceImg.top
            anchors.bottomMargin: ViaviStyle.layout.largeMargin
            anchors.right: localDeviceImg.horizontalCenter
            anchors.rightMargin: ViaviStyle.layout.veryLargeMargin

            horizontalAlignment: Text.AlignRight

            text: synoptic_res_mpoLocalText.value
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.mainInfoColor
        }

        Text {
            anchors.top: contentItem.bottom
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.horizontalCenter: localDeviceImg.horizontalCenter

            text: synoptic_res_localInfo.value
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.mainInfoColor
        }

        /* fiber link between devices */
        FixLink {
            id: fiberLinkImg

            localDevice: localDeviceImg
            remoteDevice: remoteDeviceImg
            
            onLeftLineClick: { 
               if ( !synopticRoot.bLoopbackDisplay )
                  synoptic_act_launchCableAction.invoke()
            }
               
    		onRightLineClick: { 
    		   if ( !synopticRoot.bLoopbackDisplay )
    		      synoptic_act_receiveCableAction.invoke() 
    		}

            z:1

            Text {
                anchors.top: fiberLinkImg.bottom
                anchors.topMargin: ViaviStyle.layout.smallMargin - fiberLinkImg.height * 0.4
                anchors.horizontalCenter: fiberLinkImg.horizontalCenter

                text: synoptic_res_fiberLength.value
                font: ViaviStyle.layout.largeFont
                color: ViaviStyle.colors.getTextColor(synoptic_cfg_fiberLengthStatus.value) 
            }
            
            Text {
                anchors.verticalCenter: fiberLinkImg.verticalCenter
                anchors.verticalCenterOffset: -ViaviStyle.layout.largeMargin
                anchors.left: fiberLinkImg.left

                text: synoptic_res_launchCableLength.value
                font: ViaviStyle.layout.smallFont
                // color: ViaviStyle.colors.mainInfoColor
                color: ViaviStyle.colors.activeColor
                
                MouseArea {
	    			anchors.fill: parent
	    			enabled: !synopticRoot.bLoopbackDisplay
	    			onClicked: { synoptic_act_launchCableAction.invoke() }
	    		}
            }
            
            Text {
                anchors.verticalCenter: fiberLinkImg.verticalCenter
                anchors.verticalCenterOffset: -ViaviStyle.layout.largeMargin
                anchors.right: fiberLinkImg.right

                text: synoptic_res_receiveCableLength.value
                font: ViaviStyle.layout.smallFont
                // color: ViaviStyle.colors.mainInfoColor
                color: ViaviStyle.colors.activeColor
                
                MouseArea {
	    			anchors.fill: parent
	    			enabled: !synopticRoot.bLoopbackDisplay
	    			onClicked: { synoptic_act_receiveCableAction.invoke() }
	    		}
            }
        }

        /* green arrows indicating testing in progress */
        Image {
            id: testingImg

            anchors.top: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter

            fillMode: Image.PreserveAspectFit
            width: sourceSize.width
            height: sourceSize.height


            function testingStateImage(){
                switch(synoptic_res_testingState.value){
                case synoptic_res_testingState.enums.etsGreenArrow:
                    return FiberStyle.images.fixLinkTestingGreenArrow
                case synoptic_res_testingState.enums.etsGreenArrowRight:
                    return FiberStyle.images.fixLinkTestingGreenArrowRight
                case synoptic_res_testingState.enums.etsTimer:
                    return FiberStyle.images.fixLinkTestingTimer
                }

                return FiberStyle.images.fixLinkTestingNoTesting
            }

            source: testingStateImage()

            PropertyAnimation {
                id: animationId

				running: synoptic_res_testingState.value !== synoptic_res_testingState.enums.etsNoTesting
                target: testingImg
                property: "opacity"
                from: 0
                to: 1
                duration: ViaviStyle.waitingAnimationDuration / 3
                loops: Animation.Infinite
            }
        }

        /* testing message */
        Text {
            anchors.top: testingImg.bottom
            anchors.topMargin: ViaviStyle.layout.mediumMargin
            anchors.horizontalCenter: testingImg.horizontalCenter

            text: synoptic_res_testingMessage.value
            font: ViaviStyle.layout.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
        }

        /* Exchange setup button */
        Image {
            id: exchangeSetupImg

            visible: synoptic_res_exchangeSetupEnabled.value
            anchors.top: parent.verticalCenter
            anchors.topMargin: ViaviStyle.layout.largeMargin
            anchors.horizontalCenter: parent.horizontalCenter

            fillMode: Image.PreserveAspectFit
            width: sourceSize.width
            height: sourceSize.height

            source: FiberStyle.images.fixExchangeSetupIcon
            MouseArea {
                anchors.fill: parent
                onClicked:{
                    synoptic_act_exchangeSetup.invoke()
                }
            }
        }

        /* remote device */
        FixDevice {
            id: remoteDeviceImg

            Connections{
                target: localDeviceImg

                function onConnectorYChanged() {
                	remoteDeviceImg.connectorY = localDeviceImg.connectorY
                }
            }

            anchors.right: parent.right
            anchors.rightMargin: deviceMargin

            deviceState: synoptic_res_remoteDeviceState
            deviceType: synoptic_cfg_remoteDeviceType
            functionState: synoptic_res_remoteFunctionState
            connectorYOffset: ViaviStyle.layout.fixRemoteDeviceConnectorOffset //didn't manage to put inside the device. the states and binding don't work exactly as expected

            opacity: remoteDeviceButton.pressed ? 0.7 : 1
            MouseArea {
                id: remoteDeviceButton
                anchors.fill: parent
                onClicked: synoptic_act_remoteDeviceAction.invoke()
            }
        }

        Text {
            anchors.bottom: remoteDeviceImg.top
            anchors.bottomMargin: ViaviStyle.layout.largeMargin
            anchors.left: remoteDeviceImg.horizontalCenter
            anchors.leftMargin: ViaviStyle.layout.veryLargeMargin

            horizontalAlignment: Text.AlignLeft

            text: synoptic_res_mpoRemoteText.value
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.mainInfoColor
        }


        Text {
            anchors.top: contentItem.bottom
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.horizontalCenter: remoteDeviceImg.horizontalCenter

            text: synoptic_res_remoteInfo.value
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.mainInfoColor
        }
    }

    /* origin name ( local point )*/
    Text {
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.mediumMargin
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layout.mediumMargin

        text: synoptic_res_localName.value
        font: ViaviStyle.layout.mediumBoldFont
        //color: ViaviStyle.colors.mainInfoColor
        color: ViaviStyle.colors.activeColor
        wrapMode: Text.WrapAnywhere
        horizontalAlignment: Text.AlignRight
        
		MouseArea {
	    	anchors.fill: parent
	    	onClicked: { synoptic_act_localLocationAction.invoke() }
	    }
    }


    /* extremity name (remote point) */
    Text {
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.mediumMargin
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layout.mediumMargin

        text: synoptic_res_remoteName.value
        font: ViaviStyle.layout.mediumBoldFont
        // color: ViaviStyle.colors.mainInfoColor
        color: ViaviStyle.colors.activeColor
        wrapMode: Text.WrapAnywhere
        horizontalAlignment: Text.AlignRight
        
        MouseArea {
	    	anchors.fill: parent
	    	onClicked: { synoptic_act_remoteLocationAction.invoke() }
	    }
    }
}
