import QtQuick 2.3
import QtQuick.Layouts 1.1
import elf_plugin 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui 1.0


Item {
    id: root
    property ElfData deviceState;
    property ElfData deviceType;
    property ElfData functionState;

    property int connectorX
    property int connectorY

    property int connectorYOffset: 0



    function updateConnectorXLocation(){
        connectorX = x + width / 2
    }

    function updateConnectorYLocation(){
        connectorY = y + connectorYOffset
    }

    function updateLocationXFromConnector(){
        x = connectorX - width / 2
    }

    function updateLocationYFromConnector(){
        y = connectorY - connectorYOffset
    }

    onXChanged: updateConnectorXLocation()
    onYChanged: updateConnectorYLocation()
    onWidthChanged: updateConnectorXLocation()
    onHeightChanged: updateConnectorYLocation()

    onConnectorXChanged: updateLocationXFromConnector()
    onConnectorYChanged: updateLocationYFromConnector()

    property alias deviceImageOpacity: deviceImage.opacity


    function getStateName()
    {
        if(deviceState){
            switch(deviceState.value){
            case deviceState.enums.edsLocal:
                return localState
            case deviceState.enums.edsRemote:
                return remoteState
            case deviceState.enums.edsRemoteNoLink:
                return remoteNoLinkState
            }
        }

        return notPresentState
    }

    width: deviceImage.width
    height: deviceImage.height

    Image{
        id: deviceImage
        
        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale
        source: getDeviceImagePath()
    }

    state: getStateName()

    readonly property string localState: "Local"
    readonly property string remoteState: "Remote"
    readonly property string remoteNoLinkState: "RemoteNoLink"
    readonly property string notPresentState: "NotPresent"

    function getFunctionStateImage(){
        switch(functionState.value){
        case functionState.enums.efsWait:
            return FiberStyle.images.fixFunctionWait;
        case functionState.enums.efsNoDataLink:
            return FiberStyle.images.fixFunctionNoDataLink;
        case functionState.enums.efsDataLink:
            return FiberStyle.images.fixFunctionDataLink;
        case functionState.enums.efsM2MLinkOn:
            return FiberStyle.images.fixFunctionM2MLinkOn;
        case functionState.enums.efsM2MLinkOff:
            return FiberStyle.images.fixFunctionM2MLinkOff;
        case functionState.enums.efsPow:
            return FiberStyle.images.fixFunctionPow;
        case functionState.enums.efsSrc:
            return FiberStyle.images.fixFunctionSrc;
        case functionState.enums.efsOTDR:
            return FiberStyle.images.fixFunctionOTDR;
        case functionState.enums.efsORL:
            return FiberStyle.images.fixFunctionORL;
        case functionState.enums.efsFaultFinder:
            return FiberStyle.images.fixFunctionFaultFinder;
        case functionState.enums.efsReceive:
            return FiberStyle.images.fixFunctionReceive;
        case functionState.enums.efsSend:
            return FiberStyle.images.fixFunctionSend;
        case functionState.enums.efsOEO:
            return FiberStyle.images.fixFunctionOEO;
        case functionState.enums.efsFiberLength:
            return FiberStyle.images.fixFunctionFiberLenth;
        case functionState.enums.efsSave:
            return FiberStyle.images.fixFunctionSave;
        }

        return FiberStyle.images.fixFunctionNoFunction;
    }

    Image{
        anchors.fill: parent

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        source: getFunctionStateImage()
    }

    function getDeviceImagePath() {
        //Compose a device name

        var deviceImagePath = FiberStyle.images.iconsPath + 'fcomp/fix_syn_device_'
        var typeStr = ''
        if (deviceType) {
            switch (deviceType.value) {
            case deviceType.enums.edtSmartOTDR:
            case deviceType.enums.edt2000:
                typeStr = '2000'
                break
            case deviceType.enums.edt4000:
                typeStr = '4000'
                break
            case deviceType.enums.edt5800:
                typeStr = '5800'
                break
            case deviceType.enums.edtONA_800:
                typeStr = 'ONA-800'
                break
            case deviceType.enums.edtONA_1000:
                typeStr = 'ONA-1000'
                break
            default:
                typeStr = 'ONA-800'
                break;
            }
        }
        deviceImagePath += typeStr;

        if(deviceState){
            switch(deviceState.value){
            case deviceState.enums.edsLocal:
                deviceImagePath += '.png'
                break
            case deviceState.enums.edsRemote:
                deviceImagePath += '_remote.png'
                break
            case deviceState.enums.edsNotPresent:
                deviceImagePath = FiberStyle.images.fixDeviceNotPresentImage
                break
            case deviceState.enums.edsRemoteNoLink:
                deviceImagePath += '_remote.png'
                break
            default:
                deviceImagePath += '.png'
                break
            }
        }
        return deviceImagePath
    }

    states: [
        State {
            name: localState
            PropertyChanges { target: root; deviceImageOpacity: 1.0}
        },
        State {
            name: remoteState
            PropertyChanges { target: root; deviceImageOpacity: 1.0 }
        },
        State {
            name: remoteNoLinkState
            PropertyChanges { target: root; deviceImageOpacity: 0.3;}
        },
        State {
            name: notPresentState
            PropertyChanges { target: root; deviceImageOpacity: 1.0 }
        }
    ]
}

