import QtQuick 2.9

import com.viavi.style 1.0

ViaviLayout {
    isSmallScreen: false

    property int genericTableLineHeight: 30 * scaleFactor
    property int genericTableHeaderHeight: 60 * scaleFactor
    
    property font traceUnitFont: Qt.font({pixelSize: traceUnitFontSize, family: 'Arial'})
    
    property int traceUnitFontSize: 18 * scaleFactor

    property int graphLineWidth: Math.max(1, 2 * scaleFactor)
    property int graphTickWidth: 1
    property int cursorWidth: Math.max(1, 3 * scaleFactor)
    property int smallPopupWidth: 400 * scaleFactor
    property int traceEventLineWidth: Math.max(1, 2 * scaleFactor)
    property int activeMarkerPointSize: 32 * scaleFactor
    property int traceIconEventSize: 50 * scaleFactor
    property int crossEventSize: 15 * scaleFactor
    property real fixImageScale: 1.0 * scaleFactor
    property int fixLocalDeviceConnectorOffset: 14 * scaleFactor //scaleing probably won't work
    property int fixRemoteDeviceConnectorOffset: 21 * scaleFactor //scaleing probably won't work
    property int schematicHeight: 200 * scaleFactor
    
    property int numericConfigFontSize: 41 * scaleFactor
    property int numericValueFontSize: 62 * scaleFactor
    property font numericConfigFont: getFont(numericConfigFontSize, true)
    property font numericValueFont: getFont(numericValueFontSize, true)
    property alias numericValueFontMetric: numericValueFontMetricId
    FontMetrics {
        id: numericValueFontMetricId
        font: numericValueFont
    }
}
