import QtQuick 2.7


Image{
    id: root

    property bool mipmap: false // don't have support for mipmap. add a uselles property so that we don't break functionality in other pages that try to use it. on platform that use this version it will just be ignored
    property color color: "transparent"

    property bool canvasCompleted: false

    onSourceChanged:  {
        if(!canvas.isImageLoaded(root.source)){
            canvas.loadImage(root.source)
        }
        else{
            canvas.requestPaint()
        }
    }

    onPaintedWidthChanged: if(canvasCompleted) canvas.requestPaint()
    onPaintedHeightChanged: if(canvasCompleted) canvas.requestPaint()
    
    onColorChanged: if(canvasCompleted) canvas.requestPaint()
    Canvas{
        id: canvas
        anchors.fill: parent
        contextType: "2d"
        onPaint: {
            getContext("2d")
            if(context){
                if(canvas.isImageLoaded(root.source)){
                    var drawX
                    switch(root.horizontalAlignment){
                    case Image.AlignLeft:
                        drawX = 0
                        break;
                    case Image.AlignRight:
                        drawX = width - root.paintedWidth
                        break;
                    default:
                        drawX = (width - root.paintedWidth) / 2
                        break;
                    }

                    var drawY
                    switch(root.verticalAlignment){
                    case Image.AlignTop:
                        drawY = 0
                        break;
                    case Image.AlignBottom:
                        drawY = height - root.paintedHeight
                        break;
                    default:
                        drawY = (height - root.paintedHeight) / 2
                        break;
                    }

                    context.clearRect(0, 0, width, height)


                    //context.drawImage(root.source, drawX, drawY, root.paintedWidth, root.paintedHeight)
                    var scaleX = root.paintedWidth / root.sourceSize.width
                    var scaleY = root.paintedHeight / root.sourceSize.height
                    context.save()
                    context.scale(scaleX, scaleY)
                    context.drawImage(root.source, drawX / scaleX, drawY / scaleY, root.sourceSize.width, root.sourceSize.height)
                    context.restore()

                    var saved = context.globalCompositeOperation
                    context.globalCompositeOperation = "source-in"
                    context.fillStyle = root.color
                    context.fillRect(drawX, drawY, root.paintedWidth, root.paintedHeight)
                    context.globalCompositeOperation = saved
                }else{
                    //canvas.loadImage(root.source)
                }
            }
        }

        onContextChanged: requestPaint()

        onImageLoaded: requestPaint()

        Component.onCompleted: {
            canvas.loadImage(root.source)
            root.canvasCompleted = true
        }
    }
}

