import QtQuick 2.5

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

BasicContainer {
    id: root
    
    property int noOfPorts: polarity_res_nbPorts.value
    property bool isDataAvailable: noOfPorts > 0
    
    property bool isRunning: polarity_res_isTestRunning.value
    
    property font channelNumberFont: noOfPorts > 12 ? ViaviStyle.layout.smallFont : ViaviStyle.layout.mediumBoldFont
    
    function getLinkColor( linkState )
    	{
    	if ( linkState == -1 )
    		{
    		return ViaviStyle.colors.getColor( linkState )
    		}
    	else
    		{
    		return ViaviStyle.colors.getColor( 0 )
    		}
    	}

    Column{
        id: buttonColumn
        
        width: ViaviStyle.layout.buttonHeight * 3
        
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin

        spacing: ViaviStyle.layout.mediumMargin
        
        anchors.verticalCenter: parent.verticalCenter
        
        Rectangle {
        	anchors.horizontalCenter: parent.horizontalCenter
        	
        	visible: isRunning
        	
        	color: "transparent"
		    	
	    	width: ViaviStyle.layout.buttonHeight
	    	height: width
		    	
	        ColorImage{
		    	anchors.fill: parent
                source: FiberStyle.images.fixLinkTestingTimer
	    	}
	    	
	    	RotationAnimation on rotation {
		        loops: Animation.Infinite
		        from: 0
		        to: 360
		        duration: 1000
		        running: parent.visible
		    	}
    	}
        
        ImageButton{
	    	visible: !isRunning && polarity_res_isStartMappingAvailable.value
	    	
	    	enabled: polarity_res_isStartAvailable.value
	    	
	    	anchors.horizontalCenter: parent.horizontalCenter
	    	
	    	width: ViaviStyle.layout.buttonHeight
	    	height: width
	    	
	        source: FiberStyle.images.startCircleIcon
	        
	        onClicked:{
	            polarity_act_startMapping.invoke()
	        }
    	}

        Text {
        	visible: false
            text: polarity_res_expectedPolarityLabel.value+": " + polarity_res_expectedPolarityValue.value
            font: ViaviStyle.layout.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
        }

        Text {
        	visible: true
            text: polarity_res_foundPolarityLabel.value + ": "
            font: ViaviStyle.layout.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
        }
        
        Text {
        	visible: isDataAvailable
            text: polarity_res_expectedPolarityValue.value
            font: ViaviStyle.layout.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
            
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Item {
        id: mappingItem
        anchors.right:buttonColumn.left
        anchors.rightMargin: ViaviStyle.layout.largeMargin
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layout.mediumMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.mediumMargin

        Rectangle{
            id: unitALabel
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: parent.top
            height: parent.height * 0.15
            width: parent.width / 4
            color: "#666666" //ViaviStyle.colors.mainInfoColor
            Text {
                anchors.centerIn: parent
                text: polarity_res_unitALabel.value
                font: ViaviStyle.layout.mediumBoldFont
                color: ViaviStyle.colors.activeItemTextColor
            }
        }

        Rectangle {
            id: unitAPortsRect
            anchors.top: unitALabel.bottom
            height: ViaviStyle.layout.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            color: root.isDataAvailable? "#666666" : "transparent"//ViaviStyle.colors.mainInfoColor
            border.color: "#666666"
            border.width: ViaviStyle.layout.borderSmallWidth
            
            Row {
                anchors.centerIn: parent

                Repeater {
                    //id: mappingRepeater

                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: unitAPortsRect.height * 0.9
                            width: unitAPortsRect.width / ( root.noOfPorts + 1 )
                            color: isRunning ? root.getLinkColor( 0 ) : ( isDataAvailable ? root.getLinkColor( model.linkState ) : root.getLinkColor( 0 ) )
                            border.width: ViaviStyle.layout.separatorSize
                            border.color: "#666666"//ViaviStyle.colors.mainInfoColor
                            Text {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable //&& (model.linkState !== 0)
                                text: model.portIndex
                                color: ViaviStyle.colors.activeItemTextColor
                                font: root.channelNumberFont
                            }
                        }
                    //}
                }
            }
        }

        Item {
            id: connectedRect
            anchors.top: unitAPortsRect.bottom
            height: ViaviStyle.layout.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            //color: "transparent"

            Row {
                anchors.centerIn: parent

                Repeater {
                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: connectedRect.height
                            width: connectedRect.width / ( root.noOfPorts + 1 )
                            color: "transparent"

                            Rectangle {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable && model.linkState !== 0
                                height: parent.height
                                width: ViaviStyle.layout.separatorSize * 3
                                color: ViaviStyle.colors.mainInfoColor
                            }
                        }
                  //  }
                }
            }
        }

        Rectangle {
            id: unitBPortsRect

            anchors.top: connectedRect.bottom
            height: ViaviStyle.layout.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            color: root.isDataAvailable? "#666666" : "transparent"//ViaviStyle.colors.mainInfoColor
            border.width: ViaviStyle.layout.borderSmallWidth
            border.color: "#666666"
            
            // visible: isDataAvailable

            Row {
                anchors.centerIn: parent

                Repeater {
                    id: mappingBRepeater

                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: unitBPortsRect.height * 0.9
                            width: unitBPortsRect.width /  ( root.noOfPorts + 1 )
                            color: isRunning ? root.getLinkColor( 0 ) : ( isDataAvailable ? root.getLinkColor( model.linkState ) : root.getLinkColor( 0 ) )
                            border.width: ViaviStyle.layout.separatorSize
                            border.color: "#666666"//ViaviStyle.colors.mainInfoColor
                            Text {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable && (model.linkState !== 0)
                                text: model.connectedPortIndex
                                color: ViaviStyle.colors.activeItemTextColor
                                font: root.channelNumberFont
                            }
                        }
                   // }
                }
            }
        }


        Rectangle{
            id: unitBLabel
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: unitBPortsRect.bottom
            height: parent.height * 0.15
            width: parent.width / 4
            color: "#666666"//ViaviStyle.colors.mainInfoColor
            
            // visible: isDataAvailable
            
            Text {
                anchors.centerIn: parent
                text: polarity_res_unitBLabel.value
                font: ViaviStyle.layout.mediumBoldFont
                color: ViaviStyle.colors.activeItemTextColor

            }
        }
    }
}

