import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Item{
    height: ViaviStyle.layout.buttonHeight

    Row{
        id: buttonsRow
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.mediumMargin

        spacing: ViaviStyle.layout.mediumMargin

        ImageButton{
            source: FiberStyle.images.reloadIcon

            visible: generictable_res_genericTableNbLineData.value >  generictable_res_currentIndex.value

            onClicked:{
                fcomp_act_cableLineRedoAction.invoke()
            }
        }

        ImageButton{
            source: FiberStyle.images.clearIcon

            visible: generictable_res_genericTableNbLineData.value >  generictable_res_currentIndex.value

            onClicked:{
                fcomp_act_cableLineDeleteAction.invoke()
            }
        }

        Item{
            width: ViaviStyle.layout.buttonHeight / 3

            anchors.top: parent.top
            anchors.bottom: parent.bottom
        }

        ImageButton{
            source: FiberStyle.images.deleteIcon

            visible: generictable_res_genericTableNbLineData.value > 0

            onClicked:{
                fcomp_act_cableLineClearAction.invoke()
            }
        }
    }
}
