import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui 1.0

Item {
    id: rootId

    readonly property real numberOfVisibleCurves: 4
    readonly property real cursorInfoLineMaxSize: 56

    height: ViaviStyle.layout.imageButtonHeight

    property Item trace
    property Item fiberViewContainer


    property CursorDragFiber cursorDragA
    property CursorDragFiber cursorDragB
    property CursorDragFiber cursorDragAy
    property CursorDragFiber cursorDragBy

    property CursorDragFiber cursorLockAreaTop:
        trace.lastUsedCursor === cursorDragA || trace.lastUsedCursor === cursorDragB ? cursorDragA : cursorDragAy
    property CursorDragFiber cursorLockAreaBottom:
        trace.lastUsedCursor === cursorDragA || trace.lastUsedCursor === cursorDragB ? cursorDragB : cursorDragBy

    property CursorDragFiber cursorDragAdditionalA
    property CursorDragFiber cursorDragAdditionalB

    property ElfData selectedIndex
    property ElfData unitDisplayedX
    property ElfData unitDisplayedY
    property ElfData conversionUnit
    property ElfData curveSelector
    property ElfData cursorABDistance
    
    property var distABUnitDisplayedY: (unitDisplayedY.value === "dBm") ? "dB" : unitDisplayedY.value
    


    FiberPopup {
        id:     tabPopupId

        FiberToolButton {
            visible: misc_res_traceLockVisible.value
            text: misc_res_traceLockLabel.value
            elfAction: misc_act_traceLock
        }

        FiberToolButton {
            visible: misc_res_allTraceLockVisible.value
            text: misc_res_allTraceLockLabel.value
            elfAction: misc_act_allTraceLock
        }

        FiberToolButton {
            visible: misc_res_removeTraceVisible.value
            text: misc_res_removeTraceLabel.value
            elfAction: misc_act_removeTrace
        }

        FiberToolButton {
            visible: misc_res_removeAllTraceVisible.value
            text: misc_res_removeAllTraceLabel.value
            elfAction: misc_act_removeAllTrace
        }

        FiberToolButton {
            id: hideTraceId
            visible: listViewId.count > 1 && !misc_res_hideAllTraceVisible.value
            text: misc_res_hideAllTraceLabel.value
            elfAction: misc_act_hideAllTrace
        }

        FiberToolButton {
            id: showTraceId
            visible: listViewId.count > 1 && !hideTraceId.visible
            text: misc_res_showAllTraceLabel.value
            elfAction: misc_act_showAllTrace
        }
    }

    property FiberPopup tabPopup : (misc_res_traceLockVisible.value || misc_res_allTraceLockVisible.value
                                    || misc_res_removeTraceVisible.value || misc_res_removeAllTraceVisible.value || listViewId.count > 1)
                                   ? tabPopupId : null

    Rectangle {
        id: laserSwitchBar
        width: parent.width
        height: parent.height
        color: ViaviStyle.colors.borderColor


        Image {
            id: leftIndicator

            visible: !listViewId.atXBeginning

            width: ViaviStyle.layout.largeMargin
            height: ViaviStyle.layout.largeMargin

            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layout.mediumMargin
            anchors.verticalCenter: parent.verticalCenter

            source: FiberStyle.images.indicatorLeft
            fillMode: Image.PreserveAspectFit
        }


        Image {
            id: rightIndicator

            visible: !listViewId.atXEnd

            width: ViaviStyle.layout.largeMargin
            height: ViaviStyle.layout.largeMargin

            anchors.right: rightContainer.left
            anchors.rightMargin: ViaviStyle.layout.veryLargeMargin
            anchors.verticalCenter: parent.verticalCenter

            source: FiberStyle.images.indicatorRight
            fillMode: Image.PreserveAspectFit
        }

        //trace_cfg_selectedIndex gets updated before trace_res_curveSelector_stringARRAY
        //so binding doesn't work and should update both at the same time
        //might be able to return binding if trace_res_curveSelector_stringARRAY is fixed and updated before the currentIndex
        function updateCurrentIndex()
        {
            if(listViewId.count > selectedIndex.value){
                listViewId.currentIndex = selectedIndex.value
            }
            else {
                listViewId.currentIndex = -1
            }
        }

        Connections{
            target: listViewId
            function onCountChanged() {
                laserSwitchBar.updateCurrentIndex()
            }

        }

        Connections{
            target: selectedIndex
            function onValueChanged() {
                laserSwitchBar.updateCurrentIndex()
            }
        }


        ListView {
            id: listViewId
            property bool isPmdScreen: status_res_osaMode.value === status_res_osaMode.enums.ecFunction_Pmd
            visible: (isPmdScreen && multigraphsStates_res_isPmdFftActive.value) ? false : true
            anchors.left: leftIndicator.right
            anchors.right: rightIndicator.left

            height: laserSwitchBar.height
            model: curveSelector.value


            flickableDirection: Flickable.HorizontalFlick
            clip: true

            orientation: ListView.Horizontal
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.StopAtBounds

            delegate: CheckTextButton {
                id: delegate
                height: listViewId.height
                width: listViewId.width / rootId.numberOfVisibleCurves
                centerContent: true
                uncheckedColor:  ViaviStyle.colors.traceColors[model.traceIndex]
                checked: selectedIndex.value === model.traceIndex

                mouseArea.longPressMenu: rootId.tabPopup


                text: (model.isReference ? "[" : "") + model.traceLabel + (model.isReference ? "]" : "")


                ColorImage{
                    anchors.left: delegate.textElement.right
                    anchors.bottom: delegate.textElement.bottom

                    color: delegate.checked ? ViaviStyle.colors.selectedColor : delegate.uncheckedColor
                    source: FiberStyle.images.smallRefIcon

                    visible: model.isReference
                }

                mouseArea.onClicked: {
                    selectedIndex.value = model.traceIndex;
                }

                mouseArea.onBeforePressAndHold: {
                    selectedIndex.value = model.traceIndex;
                }
            }
        }

        Item{
            id: rightContainer

            visible: status_res_cursorsEnabled.value
            width: Math.max ( ViaviStyle.layout.cursorInfoFontMetrics.averageCharacterWidth * cursorInfoLineMaxSize, parent.width / 2)
                   + lockArea.width
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right

            Item{
                visible: !additionalCursors

                anchors.fill: parent
                anchors.margins: ViaviStyle.layout.smallMargin * 2



                ImageButton {
                    id: lockButton

                    height: parent.height
                    width: height
                    anchors.left: parent.left

                    checked: trace_res_cursorsLocked.value

                    source: checked ? FiberStyle.images.cursorsLockedBtnImg : FiberStyle.images.cursorsUnlockedBtnImg

                    onClicked: {
                        trace_act_lockCursorsPosition.invoke()
                    }
                }


                CursorsLockArea {
                    id: lockArea

                    anchors.left: lockButton.right

                    topCursor: cursorLockAreaTop
                    bottomCursor: cursorLockAreaBottom

                    mouseAreaWidth: Math.max(cursorAInfoText.contentWidth, cursorBInfoText.contentWidth) + width

                    onSgnToggle: {
                        trace_act_toggleCursorsLock.invoke()
                    }
                }



                Item {
                    id: cursorInfoBar
                    anchors.left: lockArea.right
                    anchors.right: parent.right
                    height: parent.height

                    CursorInfoLabel {
                        id: cursorAInfoText
                        anchors.left: parent.left
                        anchors.right: parent.horizontalCenter
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursorX: cursorDragA
                        cursorY: cursorDragAy
                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY

                    }

                    CursorInfoLabel {
                        id: cursorBInfoText
                        anchors.left: parent.left
                        anchors.right: parent.horizontalCenter
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursorX: cursorDragB
                        cursorY: cursorDragBy
                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY

                    }

                    function getXDiff(){
                        return cursorDragA.displayedXValue
                                - cursorDragB.displayedXValue
                    }

                    function getYDiff(){
                        //Note:
                        //cursorX has X and Y, Y = f(x)
                        //cursorY has X and Y, we do not need Y value so we displayedXValue
                        //to retreive cursorY position on Y axis.

                        switch (trace_cfg_cursorDraw.value) {
                        case trace_cfg_cursorDraw.enums.ecDraw_Cursor_X:
                            return cursorDragA.displayedYValue - cursorDragB.displayedYValue

                        case trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y:
                            return cursorDragAy.displayedXValue - cursorDragBy.displayedXValue

                        case trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY:
                            return cursorDragAy.displayedXValue - cursorDragBy.displayedXValue

                        default:
                            break;
                        }

                        return 0;
                    }

                    Text {
                        id: cursorsABdistance

                        anchors.left: parent.horizontalCenter
                        //in case the cursorA cursorB info is smaller than half of the parent, allow this item to extend beyond hCenter of parent
                        //cursorsABYDiff has a fixed font and is alligned to the right. this item is aligned to it
                        anchors.leftMargin: - Math.max(0,
                                                       Math.min(cursorAInfoText.width - cursorAInfoText.contentWidth,
                                                                cursorBInfoText.width - cursorBInfoText.contentWidth)
                                                       )
                        anchors.right: cursorsABYDiff.left
                        anchors.rightMargin: ViaviStyle.layout.mediumMargin
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter
                        horizontalAlignment: Text.AlignRight

                        minimumPixelSize : ViaviStyle.layout.smallFontSize / 2
                        fontSizeMode: Text.HorizontalFit
                        font: ViaviStyle.layout.cursorInfoFont

                        text: "A-B: " +
                              Math.round(Math.abs(cursorABDistance.value)* 100) / 100 + " " +
                              unitDisplayedX.value

                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter

                    }

                    Text {
                        id: cursorsABYDiff

                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter
                        width: contentWidth

                        font: ViaviStyle.layout.cursorImportantFont

                        text: Math.round(Math.abs(cursorInfoBar.getYDiff())* 1000) / 1000 + " " + distABUnitDisplayedY

                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter
                        horizontalAlignment: Text.AlignRight
                    }

                    Text {
                        id: cursorsABsectionAttenuation

                        anchors.left: cursorsABdistance.left
                        //this will align the actual text to the text of cursorsABdistance (which is right aligned)
                        anchors.leftMargin: cursorsABdistance.width - cursorsABdistance.contentWidth
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        visible: conversionUnit.value

                        minimumPixelSize: ViaviStyle.layout.smallFontSize / 2
                        fontSizeMode: Text.Fit
                        font: ViaviStyle.layout.cursorInfoFont

                        property double attenuationValue: Math.round((Math.abs(cursorInfoBar.getYDiff()) /
                                                                      (Math.abs(cursorInfoBar.getXDiff()) * conversionUnit.value)) * 1000) / 1000
                        text:  isNaN(attenuationValue) ? ""
                                                       : attenuationValue + " " + unitDisplayedY.value + "/km"
                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter
                    }
                }
            }

            Item{
                visible: additionalCursors

                anchors.fill: parent

                Item{
                    id: aCursorsContainer

                    anchors.left: parent.left
                    anchors.right: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom

                    anchors.margins: ViaviStyle.layout.smallMargin * 2



                    ImageButton {
                        id: aLockButton

                        height: parent.height
                        width: height
                        anchors.left: parent.left

                        checked: trace_res_cursorsLocked.value

                        source: checked ? FiberStyle.images.cursorsLockedBtnImg : FiberStyle.images.cursorsUnlockedBtnImg

                        onClicked: {
                            trace_act_lockCursorsPosition.invoke()
                        }
                    }


                    CursorsLockArea{
                        id: aLockArea

                        anchors.left: aLockButton.right

                        topCursor: cursorDragA
                        bottomCursor: cursorDragAdditionalA

                        mouseAreaWidth: Math.max(aCursorAInfoText.contentWidth, aCursorBInfoText.contentWidth) + width

                        onSgnToggle: {
                            if ((trace.lastUsedCursor !== cursorDragA) && (trace.lastUsedCursor !== cursorDragAdditionalA)) {
                                trace.changeLastFocusedCursor(topCursor);
                            }
                            else {
                                if (trace.lastUsedCursor === topCursor && !trace.additionalCursorALock) {
                                    trace.changeLastFocusedCursor(bottomCursor);
                                }
                                else if (trace.lastUsedCursor === bottomCursor && !trace.additionalCursorALock) {
                                    trace.changeLastFocusedCursor(topCursor);
                                    trace.setAdditionalCursorALock(true);
                                }
                                else {
                                    trace.changeLastFocusedCursor(topCursor);
                                    trace.setAdditionalCursorALock(false);
                                }
                            }

                            trace.updateCurrentCursors()
                        }

                        onVisibleChanged: {
                            if(visible){
                                if (trace.lastUsedCursor.connectedCursor) {
                                    trace.changeLastFocusedCursor(topCursor);
                                }
                                trace.setAdditionalCursorALock(false);
                            }

                            trace.updateCurrentCursors()
                        }
                    }


                    CursorInfoLabel {
                        id: aCursorAInfoText

                        anchors.left: aLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursorX: cursorDragA

                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY
                    }

                    CursorInfoLabel {
                        id: aCursorBInfoText

                        anchors.left: aLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursorX: cursorDragAdditionalA

                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY
                    }
                }

                Item{

                    anchors.left: aCursorsContainer.right
                    anchors.right: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom

                    anchors.margins: ViaviStyle.layout.smallMargin * 2


                    CursorsLockArea{
                        id: bLockArea

                        anchors.left: parent.left

                        topCursor: cursorDragB
                        bottomCursor: cursorDragAdditionalB

                        mouseAreaWidth: Math.max(bCursorAInfoText.contentWidth, bCursorBInfoText.contentWidth) + width

                        onVisibleChanged: {
                            if(visible) {
                                trace.setAdditionalCursorBLock(false);
                            }
                        }

                        onSgnToggle: {
                            if ((trace.lastUsedCursor !== cursorDragB) && (trace.lastUsedCursor !== cursorDragAdditionalB)) {
                                trace.changeLastFocusedCursor(topCursor);
                            }
                            else {
                                if (trace.lastUsedCursor === topCursor && !trace.additionalCursorBLock) {
                                    trace.changeLastFocusedCursor(bottomCursor);
                                }
                                else if (trace.lastUsedCursor === bottomCursor && !trace.additionalCursorBLock) {
                                    trace.changeLastFocusedCursor(topCursor);
                                    trace.setAdditionalCursorBLock(true);
                                }
                                else {
                                    trace.changeLastFocusedCursor(topCursor);
                                    trace.setAdditionalCursorBLock(false);
                                }
                            }

                            trace.updateCurrentCursors()
                        }
                    }

                    CursorInfoLabel {
                        id: bCursorAInfoText

                        anchors.left: bLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursorX: cursorDragB

                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY
                    }

                    CursorInfoLabel {
                        id: bCursorBInfoText

                        anchors.left: bLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursorX: cursorDragAdditionalB

                        unitDisplayedX: rootId.unitDisplayedX
                        unitDisplayedY: rootId.unitDisplayedY
                    }
                }
            }
        }
    }
}
