import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0

Item {
    CableToggleFiberPopup { id: enablePopupId }

    property int fiber_index: 0
    property bool selected: ( fiber_index === cable_co_list.Index ) && ( cable_co_list.Label_Selection_Mode === false )

    readonly property real cellFontRatio: 2.5

    width: ( cable_co_list.MPO_Size > 4 ? 48 : 90 )
    height: width

    // Use Q_ENUM when enum not negative or supported in QML
    function cable_alarm_color ( cable_co_list, i ) 
	{
		var cable_back_col = ViaviStyle.colors.lightGray2;	
	
		if (cable_co_list.Cable_List[i] != undefined) 
		{
		  if (!cable_co_list.Cable_List[i].Fiber_To_Test) 
		  {
		      cable_back_col = ViaviStyle.colors.secondaryInfoColor;
		  } 
		  else if (cable_co_list.Cable_List[i].Fiber_Test_Done) 
		  {
		    var alarm = cable_co_list.Cable_List[i].Alarm_Status;
		    
		    // Pass
	    	if (alarm == 1) {
				cable_back_col = ViaviStyle.colors.green;
			}
			// Fail
			else if (alarm == -1) {
				cable_back_col = ViaviStyle.colors.red;
			}
			// Warning
			else if (alarm == -2) {
                cable_back_col = ViaviStyle.colors.yellow;
			}
		  }
		}
		
		return cable_back_col;
    }

    Rectangle {
        anchors.centerIn: parent
        color: cable_alarm_color( cable_co_list, fiber_index )

        width: Math.min(parent.width, parent.height) - ViaviStyle.layout.smallMargin
        height: width
        
		Image {
    		visible: (cable_co_list.Cable_List[fiber_index].Alarm_Status != 0) && cable_co_list.Cable_List[fiber_index].Fiber_Test_Done
			source: cable_co_list.Cable_List[fiber_index].Alarm_Status == 1  ? "/acterna/storage/look-and-feel/generic/Check_32.png" : "/acterna/storage/look-and-feel/generic/Cross_32.png"
			width: parent.width / 5
			height: parent.height / 5
	
			anchors.right: parent.right
			anchors.rightMargin: 2
	
			anchors.top: parent.top
			anchors.topMargin: 2
	
			fillMode: Image.PreserveAspectFit
		}

        Rectangle {
            visible: selected

            width: parent.width
            height: parent.height / 6

            color: ViaviStyle.colors.viaviPurple
            anchors.bottom: parent.bottom
        }

        Text {
            anchors.fill: parent
            text: (cable_co_list.Cable_List[fiber_index] !== undefined ? cable_co_list.Cable_List[fiber_index].Fiber_Channel : "")

            color: ViaviStyle.colors.viaviPurple
            font.pixelSize: width / cellFontRatio
            font.family: "Bitstream Vera Sans Roman"
            font.bold: true

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
        }
        
        PopupMouseArea {
            anchors.fill: parent
            longPressMenu: enablePopupId
            z: parent.z + 1
            onBeforePressAndHold: {
                cable_co_list.Label_Selection_Mode = false
                cable_co_list.Index = fiber_index
            }
	        onClicked: {
	        	cable_co_list.Label_Selection_Mode = false
	            cable_co_list.Index = fiber_index
	        }
	    }
    }
}
