<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\services\maintenance\SMTUploadStatusDto;
use app\util\SMTLogger;
use app\util\SMTUtil;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//1mn script timeout
set_time_limit(60);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
	$uploadStatus = upload_file( SMTUtil::SMARTOTU_TEMP_DIR, 'checkVpn', FALSE);

	//always remove vpn file file after upload (can contain malicious code)
	if ( file_exists( SMTUtil::SMARTOTU_TEMP_DIR.$_FILES['datafile']['name']) )
	{
		unlink(SMTUtil::SMARTOTU_TEMP_DIR.$_FILES['datafile']['name']);
	}
	
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        SMTLogger::getInstance()->trace( sprintf("Upload of vpn %s complete...", $uploadStatus->getFileName()), SMTLogger::PINFO);
    }
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>