<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\serviceshelper\maintenance\SMTUpgrade;
use app\util\upload\SMTUploadStatus;



/**
 * Begining of upload script
 * 
 */
//30mn script timeout
set_time_limit(1800);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
	$uploadStatus = upload_file( SMTUpgrade::OTU_PATCH_CURRENT_DIR, 'checkPatch');    
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>