<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;

/**
 * Measurement exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTMeasureOnDemandException extends SMTOperationException
{       
    /**
     *
     * @param string $code string error code translated from OTU error codes
     * @param string $message 
     */
    function __construct( $code = NULL, $message = NULL )
    {
        parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        return SMTMeasureOnDemandEventDto::decodeMessage( $code );
    }
}

?>