<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2020. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

/**
 * Container of dmux Dtos
 *
 * @author Sylvain Desplat
 */
class SMTConfDmuxDto extends SMTRwDto
{
    const MAX_FREQUENCY_GHZ = 196100;
    
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTDmuxDto',islist='true')
	 * @var array app\services\setup\SMTDmuxDto
	 */
	protected $configuredSwitch = array();
	
	/**
	 * @var boolean
	 */
	protected $active = FALSE;

	protected $maxFrequency = MAX_FREQUENCY_GHZ;
	/**
	 * @param boolean
	 */
	public function setActive( $active )
	{
	    $this->active = $active;
	}
	
	/**
	 * @return boolean
	 */
	public function isActive()
	{
	    return $this->active;
	}	
	
	/**
	 * @param int
	 */
	public function setMaxFrequency( $frequency )
	{
	    $this->maxFrequency = $frequency;
	}
	
	/**
	 * @return int
	 */
	public function getMaxFrequency()
	{
	    return $this->maxFrequency;
	}
	
	/**
	 *
	 * @param app\services\setup\SMTDmuxDto $switch
	 */
	function addConfigured( SMTDmuxDto $switch )
	{
	    array_push( $this->configuredSwitch, $switch );
	}

	/**
	 *
	 * @param array app\services\setup\SMTDmuxDto $switches
	 */
	function setConfigured( $switches )
	{
	    if ($switches != NULL)
	    {
    	    foreach($switches as $switch)
    	    {
    		    array_push( $this->configuredSwitch, $switch );
    	    }
	    }
	}
	
	/**
	 *
	 * @return Dmux count
	 */
	function getConfiguredDmuxCount()
	{
	    $count = 0;
	    if ($this->configuredSwitch != NULL)
	    {
	        $count = count($this->configuredSwitch);
	    }
	    return $count;
	}	
	
	/**
	 *
	 * @return array app\services\setup\SMTDmuxDto $switches
	 */
	function getConfiguredDmux()
	{
	    return $this->configuredSwitch ;
	}
	
	/**
	 *
	 * @return app\services\setup\SMTDmuxDto $switches:
	 */
	function getDmux($index)
	{
		$dmux = NULL;
		foreach($this->configuredSwitch as $switch)
		{
			if ( $switch->getIndex() === $index )
			{
			    $dmux = $switch;
			}
		}
		return $dmux;
	}
	
	/**
	 * Serialize as Json data the object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfDetSwitchDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>