<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2021. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTDto;

/**
 * OTU VPN file
 * 
 * @author Sylvain Desplat
 */
class SMTVpnDto extends SMTDto
{    
	/**
	 * Vpn file name
	 * @var string
	 */
	protected $vpnFile;

	public function setVpnFile( $vpnFile )
	{
	    $this->vpnFile = $vpnFile;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>