<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTDto;

/**
 * OTU License: software options
 * 
 * @author Sylvain Desplat
 */
class SMTLicenseDto extends SMTDto
{    
	/**
	 * Software options
	 * @var string
	 */
	protected $softwareOption;
	
	/**
	 * Software options status
	 * @var string
	 */
	protected $softwareOptionStatus;

	/**
	 * Software options name
	 * @var string
	 */
	protected $softwareOptionName;
	
	/**
	 * OTU software options
	 *
	 * @param string $softwareOption
	 */
	public function setSoftwareOption( $softwareOption )
	{
		$this->softwareOption = $softwareOption;
	}
	
	/**
	 * OTU software options status
	 *
	 * @param string $softwareOptionStatus
	 */
	public function setSoftwareOptionStatus( $softwareOptionStatus)
	{
		$this->softwareOptionStatus= $softwareOptionStatus;
	}	
	
	/**
	 * OTU software options name
	 *
	 * @param string $softwareOptionName
	 */
	public function setSoftwareOptionName( $softwareOptionName)
	{
		$this->softwareOptionName= $softwareOptionName;
	}	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>