<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;

/**
 *
 * @author sdesplat
 */
class SMTApiPortAlarmStatusListDto extends SMTApiDto
{
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\api\SMTApiPortAlarmStatusDto',islist='true')
	 * @var array app\services\api\SMTApiPortAlarmStatusDto
	 */
	protected $alarmList = array();
	
	/**
	 * @param app\services\api\SMTApiPortAlarmStatusDto
	 */
	public function addAlarm( SMTApiPortAlarmStatusDto $alarm )
	{
		array_push( $this->alarmList, $alarm);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

}