<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;

use app\util\SMTRwDto;

/**
 * Don't use super class SMTRwDto because additional field "checksum" musn't appear in public API
 * 
 * @author sdesplat
 */
abstract class SMTApiDto extends SMTRwDto
{
	const SUCCESS='success';
	const FAILURE='failure';
	
	/**
	 * cast stdClass object to a Dto. Recursively cast object properties if they are dto.
	 *
	 * @param string $dtoClassName the target dto class type
	 * @param array $json_array
	 * @param boolean $propertyNotFoundThrowException TRUE by default. Whether an exception must be thrown when a property is not found.
	 *
	 * @return $dto Dto instance
	 *
	 * @throws InvalidArgumentException if the dto class doesn't exist or if a property couldn't be found.
	 */
// 	static function forge( $dtoClassName, array &$json_array )
// 	{
// 		SMTRwDto::forge( $dtoClassName, $json_array );
// 	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}