<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events\alarms;

use app\serviceshelper\alarm\SMTAlarmSpecificProblemCode;

use app\services\alarm\SMTSystemAlarmDto;

use app\events\SMTEventDto;

/**
 * System Alarm event
 * 
 * @author Sylvain Desplat
 *
 */
class SMTSystemAlarmMessageEventDto extends SMTEventDto
{           
    
    /**
     * SYSTEM_ALARM_UPDATE event key
     * 
     * @var string
     */
    const SYSTEM_ALARM_UPDATE="SYSTEM_ALARM_UPDATE";
    
    /**
     * If system alarm dto is NULL, notify that a refresh of all system alarms should be performed.
     * 
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTSystemAlarmDto')
     * @var SMTSystemAlarmDto
     */
    protected $systemAlarm = NULL; 
    
    /**
     * 
     * @return SMTSystemAlarmDto
     */
    function getSystemAlarm()
    {
    	return $this->systemAlarm;
    }    
    
    /**
     * 
     * @param SMTSystemAlarmDto $alarm
     */
    function setSystemAlarm( SMTSystemAlarmDto $alarm )
    {
    	$this->systemAlarm = $alarm;
    	$this->setId( $alarm->getId() );
    }   
    
    /**
     * Update system alarm texts according to the current user langage.
     */
    function updateTranslations()
    {
    	if ( $this->systemAlarm != NULL )
    	{
    		$this->systemAlarm->setSpecificProblemText( SMTAlarmSpecificProblemCode::decodeSystemAlarmSpecificProblem( $this->systemAlarm->getSpecificProblemCode(), $this->systemAlarm->isCleared() ) );
    	}
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }        
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
}

?>