<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\admin;

use app\http\SMTISerializable;
use app\util\SMTDto;
use app\util\SMTAttributeInfosAnnotation;
/**
 * Application user settings
 * 
 * 
 * @author sdesplat
 */
class SMTUserDto extends SMTDto implements SMTISerializable
{   
    const USER = "user"; 
    
    /**
     * 
     * @var string
     */
    protected $login;

    /**
     *
     * @SMTAttributeInfosAnnotation(classname='app\admin\SMTRoleDto')
     * @var app\admin\SMTRoleDto
     */
    protected $role = null;    
        
    /**
     * Instanciate a user with default user role.
     *
     */
    public function __construct()
    {
        $this->role = new SMTRoleDto(SMTRoleDto::USER);  
    }
    
    /**
     *
     * @param string $name
     */
    public function setLogin($login)
    {
    	$this->login = $login;
    }
    
    /**
     *
     * @return string
     */
    public function getLogin()
    {
    	return $this->login;
    }    
    
    /**
     * Values: SMTRoleDto::USER,...
     *
     * @param string $roleName
     */
    public function setRole($roleName)
    {
   	    $this->role = new SMTRoleDto( $roleName );
    }       

    /**
     * 
     * @return \app\admin\SMTRoleDto
     */
    public function getRole()
    {
    	return $this->role;
    }    
    
    function __clone()
    {
    	// Force the copy of this->role.
    	$this->role = clone $this->role;
    }
    
    /**
     * Forge a DTO user.
     *
     * @param string $login
     * @param string SMTRoleDto name (defaults to user)
     *
     * @return \app\admin\SMTUserDto
     */
    public static function forgeUser( $login, $roleName = SMTRoleDto::USER)
    {
    	$user = new SMTUserDto();
    	$user->setLogin($login);
    	$user->setRole($roleName);
    
    	return $user;
    }    
    
    /**
     * Serialize as Json data the user object.<br> 
     * 
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
        $this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
    
    /**
     * Serialize object stored in session
     * 
     * @return multitype:string
     */
    public function __sleep()
    {
        return $this->getSerializableProperties();          
    }
    
    /**
     * Returns the serializable properties of the object.
     * 
     * @see \app\http\SMTISerializable::getSerializableProperties()
     */
    public function getSerializableProperties()
    {
        $objectProperties = get_object_vars($this);
        return array_keys( $objectProperties );        
    }
    
    /**
     * Deserialize object.
     */
    public function __wakeup()
    {        
    }
}

?>