#!/bin/bash
#set -u
#set -x

unset LANG
unset LANGUAGE
unset LC_ALL
unset LC_CTYPE
unset LC_NUMERIC

source /etc/internal-disk-settings.sh

# FORMATDEBUG=/format.log

if [[ ! -z $FORMATDEBUG ]]; then
   ## + debug
   exec 5>$FORMATDEBUG
   BASH_XTRACEFD="5"
   PS4='$LINENO: '
   set -x
   ## - debug
fi

[[ -f /etc/profile.d/platform.conf.sh ]]   && source /etc/profile.d/platform.conf.sh
[[ -f /etc/profile.d/40_otu_platform.sh ]]   && source /etc/profile.d/40_otu_platform.sh

PGNAME=$( basename $0 )

cd /

ACTION=$1

trap "{ echo 'trap SIGINT '; }" SIGINT
trap "{ echo 'trap SIGILL '; }" SIGILL
trap "{ echo 'trap SIGTERM'; }" SIGTERM
trap "{ echo 'trap SIGUSR1'; }" SIGUSR1
trap "{ echo 'trap SIGUSR2'; }" SIGUSR2
trap "{ echo 'trap SIGABRT'; }" SIGABRT
trap "{ echo 'trap SIGQUIT'; }" SIGQUIT
trap "{ echo 'trap SIGHUP '; }" SIGHUP

####################################################################
function DEBUG()
   {
   echo "$*" > /dev/console

   # pas de log vers les journaux / syslog
#    if [[ "$CFG_PLATFORM_NAME" == "OTH" ]]; then
#         otu_log $PGNAME "$*"
#    else
#         logger -t $PGNAME "$*"
#    fi
   }
   
####################################################################
function LOG()
   {
   # log sur la console ssh
   echo "$*"
   }

####################################################################
function Root_Command()
   {
   local Command="$1"
   DEBUG "Root_Command: $Command"
   
   # commande nécessitant d'être root
   sudo su - -c "$Command" > /dev/console 2>&1
   R=$?
   
   DEBUG "Root_Command ret=$R: $Command"

   return $R
   }

####################################################################
function Root_Query()
   {
   local Command="$1"
   
   # commande nécessitant d'être root
   R=$( sudo su - -c "$Command" )
   
   echo "$R"
   }
   
####################################################################
function Umount_Device()
   {
   DEV_PART=$1

   grep "$DEV_PART" /etc/mtab > /dev/null
   [ "$?" != "0" ] && return 0

   Root_Query "umount $DEV_PART" 2>&1 | grep -q "device is busy"
   [ $? == 0 ] && return 1

   [ ! -e $DEV_PART ] && return 0

   ATTEMPT=5
   while [ Root_Query "umount $DEV_PART" 2>&1 | grep -q "unmounted" ]
      do
      DEBUG "WAIT for unmount: $ATTEMPT"
      ATTEMPT=$(( ATTEMPT - 1 ))
      sleep 2
      [[ $ATTEMPT -lt 0 ]] && break
      done

   Root_Query "umount $DEV_PART" 2>&1 | grep -q "not mounted"
   [ $? == 0 ] && return 0

   return 1
   }

###########################################################
function Free_Devices()
   {
   ATTEMPT_TO_FREE=10

   Root_Command "fuser -SIGTERM -mk $*" > /dev/console 2>&1

   while Root_Command "fuser -m $*"
      do
      ATTEMPT_TO_FREE=$(( ATTEMPT_TO_FREE - 1 ))
      if [ $ATTEMPT_TO_FREE -lt 0 ]
         then
         Root_Command "fuser -SIGKILL -mk $*"
         sleep 2
         break
         fi
      usleep 200
      done
      
   Root_Command "fuser -m $*"
   for DEV in $*
      do
      Umount_Device $DEV || return 1
      done
   }

####################################################################
function Format_DISK()
   {
   DEBUG "Format_DISK"

    if ! Umount_Device $DISK_DEV_USER
      then
      DEBUG "$DISK_DEV_USER is in use"
      return 1
	fi

   Format_Partition $DISK_DEV_USER $DISK_DEV_USER_LABEL

   if [ $? != 0 ]
      then
      DEBUG "Failure while formatting $DISK_DEV_USER"
      return 1
   else
      return 0
      fi
   }
   
####################################################################
function Check_DISK()
   {
   DISK_PART="$(cat /etc/fstab | grep /user/disk | cut -f1 -d ' ')"
   if ! [ -b $DISK_PART ]
      then
      DEBUG "Unable to find partition for /user/disk"
      return 1
      fi

   R=$(Root_Query "e2label $DISK_PART")
   if [ "$R" != "User" ]
      then
      DEBUG "Bad label for /user/disk"
      return 1
      fi

   return 0
   }
   
####################################################################
function Not_Used()
   {
   echo | Root_Query "sfdisk $DEV_SDSCARD" 2>&1 | grep BLKRRPART
   if [ $? == 0 ]
      then
      DEBUG $DEV_SDSCARD" is in use"
      return 1
      fi

   DEBUG $DEV_SDSCARD" is not used"
   return 0
   }
   
####################################################################
function Make_HD_Not_Busy()
   {
   Free_Devices $DEV_SYST $DEV_USER $DEV_LOG

   if ! Umount_Device $DEV_USER
      then
      DEBUG "$DEV_USER is in use"
      return 1
      fi

   if ! Umount_Device $DEV_LOG
      then
      DEBUG "$DEV_LOG is in use"
      return 1
      fi

   if ! Umount_Device $DEV_SYST
      then
      DEBUG "$DEV_SYST is in use"
      return 1
      fi


   return 0
   }
   
####################################################################
function Make_Part()
   {
   # certaines fonctionnalites sont incohérentes lorsque le script est lancé depuis Otu (l'appli)
   # ie code retour de dd et sfdisk (création des partition) different de 0 (zéro)

   if [ ! -b $DEV_SDSCARD ]
      then
      DEBUG "No DEVICE "$DEV_SDSCARD
      return 1
      fi

   # suppression des partitions
   Root_Command "sfdisk --delete $DEV_SDSCARD" > /dev/console 2<&1
   DEBUG "delete $DEV_SDSCARD = $?"

   Root_Command "partprobe $DEV_SDSCARD" > /dev/console 2<&1
   Root_Command "sfdisk --list $DEV_SDSCARD"

   Root_Command "dd if=/dev/zero of=$DEV_SDSCARD bs=100k count=1" > /dev/console 2<&1
   DEBUG "dd $DEV_SDSCARD = $?"
   sync

   Root_Command "sfdisk --list $DEV_SDSCARD" > /dev/console 2<&1

   # test et attentes que les partitions disparaissent ?
   ATTEMPT=5
   while [ -b $DEV_LOG  -o -b $DEV_SYST -o -b $DEV_USER ]
      do
      sleep 1
      ATTEMPT=$( expr $ATTEMPT - 1 )
      if [ $ATTEMPT == 0 ]
         then
         DEBUG "Timeout while removing HD_DEVICEs"
         return 1
         fi
      done

   # plus de partitions, on les recrée
   Root_Command "sfdisk $DEV_SDSCARD << EOF
,$HD_LOG_SIZE
,$HD_SYST_SIZE
;
EOF
"
# ,,0

   CPART=$?
   DEBUG "Create part = $CPART"
   sync
   Root_Command "partprobe $DEV_SDSCARD" > /dev/console 2<&1

#   # les partitions ont été recréées,
#   # le code retour est erronné ?
#   # on va passer au formatage
#   if [ -b $DEV_LOG  && -b $DEV_SYST && -b $DEV_USER ]
#   then
#      R=0
#   fi
#
#   # partitionnement reussi, mais code retour != 0 !!!
#   if [ $R != 0 ]
#      then
#      DEBUG "Cannot create partitions table"
#      return 1
#      fi

   if [[ $CPART -ne 0 ]]; then
    # vérification des partitions (présence)
    ATTEMPT=5
    while [ 1 ]
        do
        [ -b $DEV_USER ] && [ -b $DEV_SYST ] && [ -b $DEV_LOG ] && break
        sleep 1
        ATTEMPT=$( expr $ATTEMPT - 1 )
        if [ $ATTEMPT == 0 ]
            then
            DEBUG "Timeout while waiting for DEVICEs"
            return 1
            fi
        done
   fi

   return 0
   }
   
####################################################################
function Format_Partition()
   {
   DEVICE_TO_FORMAT=$1
   DEVICE_LABEL=$2
   
   if ! Umount_Device $DEVICE_TO_FORMAT  > /dev/console 2<&1
      then
      DEBUG "$DEVICE_TO_FORMAT is in use"
      return 1
      fi

  Root_Command "mkfs.ext4 -F $DEVICE_TO_FORMAT -L ${DEVICE_LABEL}" > /dev/console 2>&1
   if [ $? != 0 ]
      then
      DEBUG "Failure while formatting $DEVICE_TO_FORMAT"
      return 1
      fi

   Root_Command "tune2fs -i 0 -c 0 $DEVICE_TO_FORMAT"  > /dev/console 2>&1

   return 0
   }

####################################################################
function CHECKHD()
   {

   if [ ! -b $DEV_SDSCARD ]
      then
      DEBUG "No "$DEV_SDSCARD
      return 1
      fi

   if [ ! -b $DEV_USER ]
      then
      DEBUG "No "$DEV_USER
      return 1
      fi

   if [ ! -b $DEV_SYST ]
      then
      DEBUG "No "$DEV_SYST
      return 1
      fi

   if [ ! -b $DEV_LOG ]
      then
      DEBUG "No "$DEV_LOG
      return 1
      fi

   if [ "$( e2label $DEV_USER )" != $HD_DEV_USER_LABEL ]
      then
      DEBUG "Bad label for "$DEV_USER
      return 1
      fi

   if [ "$( e2label $DEV_SYST )" != $HD_DEV_SYST_LABEL ]
      then
      DEBUG "Bad label for $DEV_SYST"
      return 1
      fi

   if [ "$( e2label $DEV_LOG )" != $HD_DEV_LOG_LABEL ]
      then
      DEBUG "Bad label for $DEV_LOG"
      return 1
      fi

   TESTFILE="/otu/otu-test-access-file-$RANDOM.dat"
   touch "$TESTFILE"
   if [ $? -ne 0 ]
      then
      DEBUG "Bad access for /otu"
      return 1
      fi
   rm "$TESTFILE"

   # LOG "Ok"
   return 0
   }
   
####################################################################
function Force_Udev_Full_Restart()
    {
    rm -f /etc/udev/dev.tar > /dev/console 2>&1
    }

####################################################################
function Stop_Service
    {
    local SERVICE="$1"

    DEBUG "STOP service: $SERVICE"
    Root_Command "systemctl status $SERVICE" 2>&1
    if [[ $? -eq 0 ]]; then
        Root_Command "systemctl stop $SERVICE"
        [[ $? -ne 0 ]] && DEBUG $opd $0 "Issue encountered with stopping $SERVICE."
    fi

    }

####################################################################
function Suspend_Sysd_Isu_Services()
    {
    # sur AFTH uniquement
    if [[ "$CFG_PLATFORM_NAME" == "OTH" ]]; then
#       ne pas rebooter en RESCUE
        /sbin/otu_confirm_start.sh
        for SERV in watchdog isu_ona apache2 weston otu_rfs_sync systemd-journald syslog.socket logrotate.timer logrotate systemd-remount-fs. user-harddisk.mount var-log.mount; do
            Stop_Service $SERV > /dev/console 2>&1
        done

        #release-manager.service

        /acterna/release/bin/wait_for_isu_to_close.sh

    else
#       ne pas rebooter en RESCUE
        /sbin/otu_confirm_start.sh
        /etc/init.d/watchdog stop
        /etc/init.d/otu_rfs_sync.sh stop
        /etc/init.d/isu stop
    fi

    return 0
    }

####################################################################
function Exit_Mem_Manager
{
    [[ $1 -eq 0 ]] && [[ ! -z $FORMATDEBUG ]] && rm $FORMATDEBUG
    echo "$1 $2" > user/disk/Memory_Manager.log
    [[ "$1" == "0" ]] && LOG "OK" || LOG "KO"
    reboot
    sleep 5
    reboot -f
    exit $1
}


LOG "$ACTION"

if [ "$ACTION" == "FORMATHD" ]
   then
   # FormatHD > /dev/console 2>&1
   DEBUG "Suspend_Sysd_Isu_Services"
   Suspend_Sysd_Isu_Services > /dev/console 2>&1 || Exit_Mem_Manager 1 Suspend_Sysd_Isu_Services
   # lsof +c 0 /var/log/ | awk '{print $1}'| sort | uniq
   DEBUG "Force_Udev_Full_Restart"
   Force_Udev_Full_Restart > /dev/console 2>&1
   DEBUG Make_HD_Not_Busy
   Make_HD_Not_Busy > /dev/console 2>&1 || Exit_Mem_Manager 1 Make_HD_Not_Busy
   DEBUG Not_Used
   Not_Used > /dev/console 2>&1    || Exit_Mem_Manager 1 Not_Used
   sleep 1
   DEBUG Make_Part
   Make_Part > /dev/console 2>&1   || Exit_Mem_Manager 1 Make_Part
   DEBUG Format_Partition
   Format_Partition $DEV_USER $HD_DEV_USER_LABEL > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_USER-$HD_DEV_USER_LABEL"
   Format_Partition $DEV_SYST $HD_DEV_SYST_LABEL > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_SYST-$HD_DEV_SYST_LABEL"
   Format_Partition $DEV_LOG  $HD_DEV_LOG_LABEL  > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_LOG-$HD_DEV_LOG_LABEL"
   DEBUG udevadm
   udevadm trigger --name=$(basename ${DEV_SDSCARD})  > /dev/console 2>&1
   DEBUG Start_Sysd_Isu_Services
   if grep -q /dev/mmcblk0 /proc/cmdline ; then
      Exit_Mem_Manager 0
   fi
   exit 0
elif [ "$ACTION" == "FREEHD" ]
   then
   Make_HD_Not_Busy > /dev/console 2>&1 || Exit_Mem_Manager 1 Make_HD_Not_Busy
   Not_Used > /dev/console 2>&1    || Exit_Mem_Manager 1 Not_Used
   Exit_Mem_Manager 0
elif [ "$ACTION" == "FORMATSYST" ]
   then
   Suspend_Sysd_Isu_Services > /dev/console 2>&1 || Exit_Mem_Manager 1 Suspend_Sysd_Isu_Services
   Force_Udev_Full_Restart > /dev/console 2>&1
   Format_Partition $DEV_SYST $HD_DEV_SYST_LABEL > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_SYST-$HD_DEV_SYST_LABEL"
   Exit_Mem_Manager 0
elif [ "$ACTION" == "FORMATUSER" ]
   then
   Suspend_Sysd_Isu_Services > /dev/console 2>&1 || Exit_Mem_Manager 1 Suspend_Sysd_Isu_Services
   Force_Udev_Full_Restart > /dev/console 2>&1
   Format_Partition $DEV_USER $HD_DEV_USER_LABEL > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_USER-$HD_DEV_USER_LABEL"
   Exit_Mem_Manager 0
elif [ "$ACTION" == "FORMATLOG" ]
   then
   Suspend_Sysd_Isu_Services > /dev/console 2>&1 || Exit_Mem_Manager 1 Suspend_Sysd_Isu_Services
   Force_Udev_Full_Restart > /dev/console 2>&1
   Format_Partition $DEV_LOG $HD_DEV_LOG_LABEL > /dev/console 2>&1 || Exit_Mem_Manager 1 "Format_Partition-$DEV_LOG-$HD_DEV_LOG_LABEL"
   Exit_Mem_Manager $?
elif [ "$ACTION" == "CHECKHD" ]
   then
   CHECKHD
   R=$?
   [[ "$R" == "0" ]] && echo "OK" || LOG "KO"
   exit $?
else
   LOG "Usage: "$0" FORMATHD | FREEHD | CHECKHD | FORMATLOG | FORMATSYST | FORMATUSER"
   fi

LOG "KO"
exit 1
