import QtQuick 2.9

QtObject {
    
    // TODO: in the future consider computing the scale factor
    property real scaleFactor: 1.0

    // The font family used for all the fonts
    property string fontFamily: "DejaVu Sans"

    // Font sizes
    property int minuteFontSize: 12 * scaleFactor
    property int smallFontSize: 13 * scaleFactor
    property int mediumFontSize: 16 * scaleFactor
    property int largeFontSize: 19 * scaleFactor
    property int veryLargeFontSize: 22 * scaleFactor

    // Available font objects
    property font smallFont: getFont(smallFontSize, false)
    property font smallBoldFont: getFont(smallFontSize, true)
    property font mediumFont: getFont(mediumFontSize, false)
    property font mediumBoldFont: getFont(mediumFontSize, true)
    property font largeFont: getFont(largeFontSize, false)
    property font largeBoldFont: getFont(largeFontSize, true)
    property font veryLargeFont: getFont(veryLargeFontSize, false)
    property font veryLargeBoldFont: getFont(veryLargeFontSize, true)

    // Helper function to create fonts
    function getFont(fontSize, isBold)
    {
        return Qt.font({ pixelSize: fontSize, family: fontFamily, bold: isBold });
    }

    // Default fonts for different components
    property font textFont: mediumFont
    property font textBoldFont: mediumBoldFont
    property font titleFont: largeBoldFont

    // Value to be used for margins and spacing
    property int smallMargin: 5 * scaleFactor
    property int mediumMargin: 10 * scaleFactor
    property int largeMargin: 20 * scaleFactor
    property int veryLargeMargin: 40 * scaleFactor

    // Border widths
    property int borderWidth: 2 * scaleFactor

    // Default component sizes
    property int defaultButtonWidth: 100
    property int defaultButtonHeight: 20
    property int defaultTextFieldWidth: 300
}