from copy import deepcopy
from .json_proxy import JsonProxy
from .spec import WEntries
from .formateur import Formateur


def to_feet(meter: float) -> float:
    """

    :param meter:
    :return:
    """
    return meter / 0.3048


class WaldoBuilder:
    def __init__(self, cdm: JsonProxy):
        self._cdm: JsonProxy = cdm
        self._output: dict = {}
        self._formateur = Formateur()

    def store_logs(self, variable_to_write) -> None:
        file_to_store_in = "/tmp/formateur_logs.txt"
        str_to_write = str(variable_to_write)
        with open(file_to_store_in, 'a+') as fs:
            fs.write(str_to_write + '//')
        

    def reset(self):
        """TODO
        """
        self._output.clear()

    def get(self):
        """

        :return:
        """
        out = deepcopy(self._output)
        self.reset()
        return out

    def make(self):
        """TODO
        """
        self._add_label()

    def _add_label(self):
        """TODO
        """
        
        label = {}

        tester = self._cdm.find(WEntries.tester.path)[0]
        label[WEntries.tester.key] = tester

        wireCenterClli = self._cdm.find(WEntries.wireCenterClli.path)[0]
        label[WEntries.wireCenterClli.key] = wireCenterClli

        cfas = self._cdm.find(WEntries.cfas.path)[0]
        label[WEntries.cfas.key] = cfas

        a_loc = self._cdm.find(WEntries.a_loc.path)[0]
        label[WEntries.a_loc.key] = a_loc

        z_loc = self._cdm.find(WEntries.z_loc.path)[0]
        label[WEntries.z_loc.key] = z_loc

        dateTested = self._cdm.find(WEntries.dateTested.path)[0]
        label[WEntries.dateTested.key] = self._formateur.format_date_formateur(dateTested)

        model = self._cdm.find(WEntries.model.path)[0]
        label[WEntries.model.key] = model

        serialNumber = self._cdm.find(WEntries.serialNumber.path)[0]
        label[WEntries.serialNumber.key] = self._formateur.format_the_serial_number_formateur(serialNumber)

        Version = self._cdm.find(WEntries.Version.path)[0]
        label[WEntries.Version.key] = Version

        calibrationDate = self._cdm.find(WEntries.calibrationDate.path)[0]
        label[WEntries.calibrationDate.key] = calibrationDate

        spliceLossThreshold = self._cdm.find(WEntries.spliceLossThreshold.path)[0]
        label[WEntries.spliceLossThreshold.key] = spliceLossThreshold

        connectorLossThreshold = self._cdm.find(WEntries.connectorLossThreshold.path)[0]
        label[WEntries.connectorLossThreshold.key] = connectorLossThreshold

        eventReflectanceThreshold = self._cdm.find(WEntries.eventReflectanceThreshold.path)[0]
        label[WEntries.eventReflectanceThreshold.key] = eventReflectanceThreshold

        strandOrlThreshold = self._cdm.find(WEntries.strandOrlThreshold.path)[0]
        label[WEntries.strandOrlThreshold.key] = strandOrlThreshold

        cable_id = self._cdm.find(WEntries.cable_id.path)[0]
        label[WEntries.cable_id.key] = cable_id

        self._add_tested(label)

        self._output[WEntries.label.key] = label

    def _add_tested(self, label: dict):
        """TODO

        :param label:
        """
        tested = []

        cdm_tests = self._cdm.find("$.tests")[0]

        for cdm_test in cdm_tests:
            cdm_test = JsonProxy(cdm_test)

            sub_tested = {}

            strand = cdm_test.find(WEntries.strand.path)[0]
            if strand:
                strand = int(strand)
            sub_tested[WEntries.strand.key] = strand

            span_length = cdm_test.find(WEntries.span_length.path)[0]
            if span_length:
                span_length = int(to_feet(float(span_length)))
            sub_tested[WEntries.span_length.key] = span_length

            pass_fail = cdm_test.find(WEntries.pass_fail.path)[0]
            sub_tested[WEntries.pass_fail.key] = pass_fail

            self._add_link_measurements(sub_tested, cdm_test)
            self._add_events(sub_tested, cdm_test)

            tested.append(sub_tested)

        label[WEntries.tested.key] = tested

    def _add_link_measurements(self, sub_tested: dict, cdm_test: JsonProxy):
        """

        :param sub_tested:
        :param cdm_test:
        :return:
        """
        link_measurements = []

        measured_results = cdm_test.find(WEntries.measurements.path)[0]

        for result in measured_results:
            result = JsonProxy(result)
            link_measurement = {}

            wavelength = result.find(WEntries.wavelength.path)[0]
            if wavelength:
                wavelength = int(wavelength)
            link_measurement[WEntries.wavelength.key] = wavelength

            total_loss = result.find(WEntries.total_loss.path)[0]
            link_measurement[WEntries.total_loss.key] = total_loss

            total_orl = result.find(WEntries.total_orl.path)[0]
            link_measurement[WEntries.total_orl.key] = total_orl

            link_measurements.append(link_measurement)

        sub_tested[WEntries.link_measurements.key] = link_measurements

    def _add_events(self, sub_tested: dict, cdm_test: JsonProxy):
        """TODO

        :param sub_tested:
        :param cdm_test:
        """

        path = "$.results.data.otdrResults.measuredResults[*].events[*].idSlm"
        id_slms = cdm_test.find(path)
        self.store_logs(id_slms)

        max_event_nbr = max(id_slms)
        self.store_logs(max_event_nbr)

        cdm_otdr_results = cdm_test.find("$.results.data.otdrResults")[0]
        cdm_otdr_results = JsonProxy(cdm_otdr_results)
        self.store_logs(cdm_otdr_results)

        events = []

        for idx in range(max_event_nbr):
            event = {
                WEntries.event_number.key: idx
            }

            path = WEntries.distance_from_a.path.format(idx + 1)
            distance_from_a = cdm_otdr_results.find(path)[0]
            #if distance_from_a:
            distance_from_a = int(to_feet(float(distance_from_a)))
            event[WEntries.distance_from_a.key] = distance_from_a

            path = WEntries.event_type.path.format(idx + 1)
            event_type = cdm_otdr_results.find(path)[0]
            event[WEntries.event_type.key] = event_type

            event[WEntries.event_attributes.key] = [event_type]
            self.store_logs(event)
            event = self._formateur.format_eventType_formateur(event)

            self._add_measurements(event, cdm_test)

            events.append(event)
        self.store_logs(events)
        sub_tested[WEntries.events.key] = events

    def _add_measurements(self, event: dict, cdm_test: JsonProxy):
        """TODO

        :param event:
        :param cdm_test:
        """
        measurements = []

        event_number = event[WEntries.event_number.key] + 1

        measured_results = cdm_test.find(WEntries.measurements.path)[0]

        for cdm_result in measured_results:
            cdm_result = JsonProxy(cdm_result)
            measurement = {}

            path = WEntries.wavelength.path
            wavelength = cdm_result.find(path)[0]
            measurement[WEntries.wavelength.key] = wavelength

            path = WEntries.reflectance.path.format(event_number)
            reflectance = cdm_result.find(path)[0]
            if reflectance:
                reflectance = int(reflectance)
            else:
                reflectance = None

            measurement[WEntries.reflectance.key] = reflectance

            path = WEntries.loss.path.format(event_number)
            loss = cdm_result.find(path)[0]
            if not loss:
                loss = None
            measurement[WEntries.loss.key] = loss

            path = WEntries.loss_to_event.path.format(event_number)
            loss_to_event = cdm_result.find(path)[0]
            if not loss_to_event:
                loss_to_event = None

            measurement[WEntries.loss_to_event.key] = loss_to_event

            measurement[WEntries.span_loss_thru_event.key] = loss_to_event

            measurements.append(measurement)

        event[WEntries.measurements.key] = measurements
