import logging
log = logging.getLogger(__name__)


class Entry:
    def __init__(self, key: str, path: str = None):
        self.key = key
        if path is not None:
            self.path = path

class WEntries:


    
    #Waldo Label
    label: Entry = Entry("Label")
    tester: Entry = Entry("tester", "$.workflow.techInfo.techId")
    wireCenterClli: Entry = Entry("wireCenterClli", "$.workflow.attributes.jobComments")
    cfas: Entry = Entry("cfas", "$.workflow.workOrderId")
    a_loc: Entry = Entry("aLoc", "$.tests[0].configuration.otdrSettings.fiber.locationA")
    z_loc: Entry = Entry("zLoc", "$.tests[0].configuration.otdrSettings.fiber.locationB")
    dateTested: Entry = Entry("dateTested", "$.tests[0].results.testTime")  ## warning multiple calibration date
    model: Entry = Entry("model", "$.assetInfo.model")  # warning multiple calibration date
    serialNumber: Entry = Entry("serialNumber", "$.assetInfo.uniqueId")
    Version: Entry = Entry("Version", "$.assetInfo.swVersion")
    calibrationDate: Entry = Entry("calibrationDate", "$.assetInfo.modulesInfo[0].calibrationDate")
    spliceLossThreshold: Entry = Entry("spliceLossThreshold", "$.tests[0].configuration.otdrSettings.alarmThresholds.spliceLossdB")
    connectorLossThreshold: Entry = Entry("connectorLossThreshold", "$.tests[0].configuration.otdrSettings.alarmThresholds.connectorLossdB")
    eventReflectanceThreshold: Entry = Entry("eventReflectanceThreshold", "$.tests[0].configuration.otdrSettings.alarmThresholds.reflectancedB")
    strandOrlThreshold: Entry = Entry("strandOrlThreshold","$.tests[0].configuration.otdrSettings.alarmThresholds.orldB")
    cable_id: Entry = Entry("cableId", "$.tests[0].configuration.otdrSettings.fiber.cableId")


    tested: Entry = Entry("Tested")
    strand: Entry = Entry("strand", "$.configuration.otdrSettings.fiber.number")
    span_length: Entry = Entry("spanLength", "$.results.data.otdrResults.measuredResults[0].fiberLengthM")
    pass_fail: Entry = Entry("passFail", "$.results.status")
    link_measurements: Entry = Entry("linkMeasurements")
    wavelength: Entry = Entry("wavelength", "$.wavelengthNm")
    total_loss: Entry = Entry("totalLoss", "$.linkLossdB")
    total_orl: Entry = Entry("totalORL", "$.linkOrldB")



    events: Entry = Entry("events")
    event_number: Entry = Entry("eventNumber")
    distance_from_a: Entry = Entry("distanceFromA", "$.measuredResults[*].events.[?(@.idSlm=={})].distanceM")
    event_type: Entry = Entry("eventType", "$.measuredResults[*].events.[?(@.idSlm=={})].eventType")
    event_attributes: Entry = Entry("eventAttributes")
    measurements: Entry = Entry("measurements", "$.results.data.otdrResults.measuredResults")
    reflectance: Entry = Entry("reflectance", "$.events[?(@.idSlm=={})].reflectancedB")
    loss: Entry = Entry("loss", "$.events[?(@.idSlm=={})].lossdB")
    loss_to_event: Entry = Entry("lossToEvent", "$.events[?(@.idSlm=={})].cumulativeLossdB")
    span_loss_thru_event: Entry = Entry("spanLossThruEvent")



