
import qrcode
from os import makedirs, path

QR_CODE_LIMIT = 1200


class QrCodeGenerator:
    def __init__(self):
        self.__images = list()

    def generate(self, data: str, content_type: int, make_header=None):
        blobs = [data[i:i + QR_CODE_LIMIT] for i in range(0, len(data), QR_CODE_LIMIT)]
        cnt = len(blobs)

        for nr in range(cnt):
            header = ""
            if make_header is not None:
                header = make_header('ccc', content_type, nr + 1, cnt)

            bytes_data = header + blobs[nr]
            print(bytes_data)
            qr = qrcode.QRCode(
                version=None,
                error_correction=qrcode.constants.ERROR_CORRECT_L,
                box_size=10,
                border=4,
            )
            qr.add_data(bytes_data)
            qr.make(fit=True)
            print("QRCODE version:%i" % qr.version)
            self.__images.append(qr.make_image(fill_color="black", back_color="white"))

    def save(self, output="./output"):
        cnt = len(self.__images)

        for nr in range(cnt):
            filename = "%s_%i_%i.png" % (output, nr, cnt - 1)
            print(filename)

            makedirs(path.dirname(filename), exist_ok=True)
            with open(filename, "wb") as out:
                self.__images[nr].save(out)

