class CommandInvoker(object):
    '''
    Class to call automatically a methode with in parameters,
    the call name
    Used to call for exemple print_help(... -> __output.print_msg("help"...
    '''

    def __init__(self, obj, function, append):
        self.obj = obj
        self.func = function
        self.append = append

    def __call__(self, *args, **kwargs):
        for key in list(self.append.keys()):
            kwargs[key] = self.append[key]
        function = self.obj.__getattribute__(self.func)
        return function(*args, **kwargs)
