init-odm_init()
{
    isODMUpdated[1]=-1
    isODMUpdated[2]=-1

    # ODM management
    #
    # Search for HETNET modules in position 1 or 2 and look for a ODM module
    for i in `seq 1 2`;
    do
    qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B26-"
    if [ $? -eq 0 ]
    then
        echo "ODM module found at address $i"

        # Program the ODM Module's fpga if needed
        load_odm_fpga.sh ${i}
        isODMUpdated[$i]=$?
    fi
    done

    if   [[ "${isODMUpdated[1]}" -eq "0" ]] \
      || [[ "${isODMUpdated[2]}" -eq "0" ]]
    then
        echo "A ODM module has been updated - Reboot in 5 seconds"

        # Simulate Otu launch to avoid rebooting in rescue mode - if script exists
        [ -f /sbin/otu_confirm_start.sh ] && otu_confirm_start.sh

        sleep 5

        reboot
        exit -1
    fi
}
