#!/usr/bin/env bash
#
# Mount unused partition of a double FS system into /mnt/fs/unused
#

MOUNT_DIR="/mnt/fs/unused_part"

source /etc/otu/otuparts.sh

if [ ! -b ${ALT_PART} ] ; then
  echo "The other partition has not been found, aborting"
  exit 1
fi

if [ -d ${MOUNT_DIR} ] ; then
  if $(mountpoint -q ${MOUNT_DIR}) ; then
    echo "${MOUNT_DIR} is already populated, aborting"
    exit 2
  fi
fi

mkdir -p ${MOUNT_DIR}
mount -o ro ${ALT_PART} ${MOUNT_DIR}

exit 0