#!/bin/sh
### BEGIN INIT INFO
# Provides:          hostname
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Set hostname based on /etc/hostname
### END INIT INFO

IS_OTU_HRD="NO"

# serial-number is filled by u-boot
DTB_SN=$(cat /proc/device-tree/board/serial-number)

# check if we are otu or not, because otu maange hostname it's own
if [[ -f /usr/lib/otu_functions ]] ; then
	source /usr/lib/otu_functions
	is_cotu_hw
	if [[ $? -ne 1 ]] ; then
		# Not an Otu check if hostname contains otu and switch it back to base version (migrating from OTU -> eotdrv2)
		rm -f /etc/hostname
	else
		IS_OTU_HRD="YES"
	fi
fi

if [[ "$IS_OTU_HRD" == "NO" ]]  # update /etc/hostname at every boot, if SN change.
then
  echo "base-$(cat /proc/device-tree/model | sed "s/mts//g")-$DTB_SN" > /etc/hostname
elif ! test -f /etc/hostname    # on otu do not update /etc/hostname file every boot
then
  echo "otu-5000-$DTB_SN" > /etc/hostname
fi

hostname $(cat /etc/hostname)

# if there is no /etc/hosts file, create a default file (usually it is done by Isu... but for otu it is not!!!)
if ! [ -f /etc/hosts ]
then
  {
    echo "# Loopback address";  echo "127.0.0.1       localhost.localdomain localhost";
    echo "::1     localhost6.localdomain6 localhost6"; echo "127.0.0.1     $(hostname)";
  } > /etc/hosts
fi
