#!/bin/sh

[ -f /etc/platform.conf ] && source /etc/platform.conf
[ -f /etc/profile.d/40_otu_platform.sh ] && source /etc/profile.d/40_otu_platform.sh

echo "<?xml version='1.0' encoding='UTF-8'?>
<device>
    <service id='deviced'>
        <param id='version'>1</param>
    </service>"
if [ -f /proc/device-tree/model ]
then
    VAR=$(strings /proc/device-tree/model)
    echo "<env id='model'>$VAR</env>"
    echo "<model>$VAR</model>"
fi
for env in $(env | grep CFG);
do
    VAR=$(echo $env | cut -d "=" -f 1)
    if [ -n "${!VAR}" ]
    then
        echo "<env id='$VAR'>${!VAR}</env>"
    fi
done
echo "</device>"
