import QtQuick 2.5

Item {

    property int screenWidth: platform.screenWidth
    property int screenHeight: platform.screenHeight

    property int defaultScreenWidth: 1280
    property int defaultScreenHeight: 756

    property bool isSmallScreen: false

    function getDynamicScaleFactor(){
        var xScale = 1.0 * screenWidth / defaultScreenWidth
        var yScale = 1.0 * screenHeight / defaultScreenHeight

        return Math.min(xScale, yScale)
    }

    //calculated dynamically if the expected screen size differes from the actuall screen size
    readonly property real dynamicScaleFactor: getDynamicScaleFactor()

    //this can be changed when create a new instance of the layout for a new resolution
    property real staticScaleFactor: 1.0

    //scale factor
    //can be used as a quick generic way to scale default sizes needed for other resolution - fonts size, component width/height
    readonly property real scaleFactor: dynamicScaleFactor * staticScaleFactor

    // font sizes
    // by default they will use the initial value and be scaled by scaleFactor, but can be overridden in specific style files
    property int minuteFontSize: 12 * scaleFactor
    property int smallFontSize: 13 * scaleFactor
    property int mediumFontSize: 16 * scaleFactor
    property int largeFontSize: 19 * scaleFactor
    property int veryLargeFontSize: 22 * scaleFactor

    property int traceUnitFontSize: 18 * scaleFactor

    function getFont(fontSize, isBold){
        return Qt.font({
                           pixelSize: fontSize, family:"DejaVu Sans", bold: isBold
                       })
    }

    //basic fonts based on sizes
    //these fonst can be used directly in specific qml if you don't expect diferences between different ViaviSyle files
    property font minuteFont: getFont(minuteFontSize, false)
    property font minuteBoldFont: getFont(minuteFontSize, true)
    property font smallFont: getFont(smallFontSize, false)
    property font smallBoldFont: getFont(smallFontSize, true)
    property font mediumFont: getFont(mediumFontSize, false)
    property font mediumBoldFont: getFont(mediumFontSize, true)
    property font largeFont: getFont(largeFontSize, false)
    property font largeBoldFont: getFont(largeFontSize, true)
    property font veryLargeFont: getFont(veryLargeFontSize, false)
    property font veryLargeBoldFont: getFont(veryLargeFontSize, true)
    property font traceUnitFont: Qt.font({pixelSize: traceUnitFontSize, family: 'Arial'})

    property alias largeBoldFontMetrics: largeBoldFontMetricsId
    FontMetrics {
        id: largeBoldFontMetricsId
        font: largeBoldFont
    }

    // fonts logic
    // sort of alias to the basic fonts with the posibility to the "basic" font that is based upon in diffrent Style files.

    property font headerFont: largeBoldFont //table header font
    property font tableFont: veryLargeFont //table cell font
    property font tableTitleFont: largeBoldFont
    property font cursorInfoFont: mediumFont
    property font cursorImportantFont: mediumBoldFont
    property alias cursorInfoFontMetrics: cursorInfoFontMetricsId

    FontMetrics {
        id: cursorInfoFontMetricsId
        font: cursorInfoFont
    }
    

    property font infoTextFont: smallFont //generic information, non interactable component
    property font activeTextFont: mediumFont //active items: buttons/toggles ...
    property alias activeTextFontMetrics: activeTextFontMetricsId
    property font activeBoldTextFont: mediumBoldFont //active items: buttons/toggles ...

    FontMetrics {
        id: activeTextFontMetricsId
        font: activeTextFont
    }

    property font titleTextFont: largeBoldFont

    //fonts metrics
    property alias headerFontMetrics: headerFontMetricsId
    property alias tableFontMetrics: tableFontMetricsId
    property alias titleTextFontMetrics: titleTextFontMetricsId

    FontMetrics {
        id: headerFontMetricsId
        font: headerFont
    }

    FontMetrics {
        id: tableFontMetricsId
        font: tableFont
    }

    FontMetrics {
        id: titleTextFontMetricsId
        font: titleTextFont
    }

    // specific fonts
    property int keyboardTextFontSize: 23 * scaleFactor
    property font keyboardTextFont: getFont(keyboardTextFontSize, false)
    property alias keyboardTextFontMetrics: keyboardTextFontMetricsId

    FontMetrics {
        id: keyboardTextFontMetricsId
        font: keyboardTextFont
    }

    property int numericConfigFontSize: 41 * scaleFactor
    property int numericValueFontSize: 62 * scaleFactor

    property font numericConfigFont: getFont(numericConfigFontSize, true)
    property font numericValueFont: getFont(numericValueFontSize, true)
    property alias numericValueFontMetric: numericValueFontMetricId

    FontMetrics {
        id: numericValueFontMetricId
        font: numericValueFont
    }

    property int separatorSize: 1
    property int borderSize: Math.max(1, 2 * scaleFactor)
    property int borderSmallWidth: 1

    property int smallMargin: 4 * scaleFactor
    property int mediumMargin: 10 * scaleFactor
    property int largeMargin: 20 * scaleFactor
    property int veryLargeMargin: 40 * scaleFactor

    property int buttonHeight: 50 * scaleFactor
    property int imageButtonHeight: buttonHeight
    property real tableColumnImageScale: 0.85
    property int keyboardButtonHeight: 80 * scaleFactor
    property int keyboardAlphaButtonWidth: 75 * scaleFactor
    property int keyboardNumericButtonWidth: 90 * scaleFactor

    property int genericTableLineHeight: 30 * scaleFactor
    property int genericTableHeaderHeight: 60 * scaleFactor

    property int grapLineWidth: Math.max(1, 2 * scaleFactor)
    property int graphTickWidth: 1

    property int cursorWidth: Math.max(1, 3 * scaleFactor)

    property int smallPopupWidth: 400 * scaleFactor

    property real fixImageScale: 1.0 * scaleFactor

    property int fixLocalDeviceConnectorOffset: 14 * scaleFactor //scaleing probably won't work
    property int fixRemoteDeviceConnectorOffset: 21 * scaleFactor //scaleing probably won't work

    property int traceEventLineWidth: Math.max(1, 2 * scaleFactor)

    property int activeMarkerPointSize: 32 * scaleFactor

    property int traceIconEventSize: 50 * scaleFactor

    property int schematicHeight: 200 * scaleFactor

    property int crossEventSize: 15 * scaleFactor

    /* Menu dimensions */
    property int menuLineHeight: 45 * scaleFactor

    property int softKeysWidth: 2 * buttonHeight

    property int  keyboardButtonMargin: 3 //TODO scale, but first verify if it's really needed

    property int dragableSeparatorWidth: 4 * buttonHeight

    property int pictogramEventSize: 40 * scaleFactor
}
