import QtQuick 2.0

QtObject {


    property string iconsCustomIsuPath: genericConfig_res_imageCustomPath.value + "/isu/"
    property string iconsGenericPath: "/acterna/storage/look-and-feel/generic/"
    property string iconsPath: "/acterna/storage/fo/"
    property string iconsIsuPath: "/acterna/storage/isu/icons/"

    function getAlarmIcon(alarm) {
        switch(alarm) {
        case -1:
            return iconsCustomIsuPath + "Dialog_Icon_Fail.png"
        case 1:
            return iconsCustomIsuPath + "Dialog_Icon_Pass.png"
        default:
            return ""
        }
    }

    //Images

    property string iconFailedEvent: iconsPath + "report/Fail.png"
    property string iconPassedEvent: iconsPath + "report/Pass.png"
    property string iconFailedAlarmStatus: iconsPath + "report/Wizard_Fail.png"
    property string iconPassedAlarmStatus: iconsPath + "report/Wizard_Pass.png"

    property string smallRefIcon: iconsPath + "report/ref.png"
    property string closeButtonIcon: iconsCustomIsuPath + "Icon_Sk_Gen_Cancel.png"
    property string filterIcon: iconsCustomIsuPath + "Icon_SK_Filter.png"
    property string filterIconEmpty: iconsCustomIsuPath + "Icon_SK_Filter_Empty.png"
    property string addIcon: iconsCustomIsuPath + "Icon_SK_Add.png"
    property string aboutIcon: iconsCustomIsuPath + "Icon_Sk_Gen_About.png"
    property string helpIcon: iconsCustomIsuPath + "Icon_Sk_Gen_Help.png"
    property string backIcon: iconsCustomIsuPath + "Icon_Sk_Back.png"
    property string applyIcon: iconsCustomIsuPath + "Icon_Sk_Apply.png"

    property string saveIcon: iconsGenericPath + "icon_job_save.png"
    property string freezeIcon: iconsGenericPath + 'camera-freeze-wod-128.png'
    property string cameraIcon: iconsGenericPath + 'camera-simple-wod-128.png'
    property string fullScreenIcon: iconsGenericPath + 'fullscreen-wod-128.png'
    property string gridOfFourIcon: iconsGenericPath + 'elements4-wod-128.png'
    property string zoomInMagnifierIcon: iconsGenericPath + "zoom_in-simple-wod-128.png"
    property string zoomOutMagnifierIcon: iconsGenericPath + "zoom_out-simple-wod-128.png"
    property string actionPlayIcon: iconsGenericPath + 'play-circle-o-wod-128.png'
    property string commentIcon: iconsGenericPath + 'comment-o-wod-128.png'
    property string downloadIcon: iconsGenericPath + 'download-wod-128.png'

    //TODO: Move? These 2 are a bit too Microscope specific
    property string focusActionIcon: iconsGenericPath + 'target3-wod-128.png'
    property string focusedIcon: iconsGenericPath + 'target-wod-128.png'

    
    property string startCircleIcon: iconsGenericPath + "Icon_Circle_Play.png"

    property string reloadIcon: iconsCustomIsuPath + "Icon_Sk_Gen_Reload.png"
    property string deleteIcon: iconsCustomIsuPath + "Icon_Sk_Gen_Cancel.png"
    property string clearIcon:iconsGenericPath + "Icon_Broom.png"

    property string factoryResetIcon: iconsGenericPath + "Icon_Factory_Reset.png"
    property string iconOpenFile: iconsGenericPath+ "icon_popup_view_file.png"
    property string iconSettings: iconsGenericPath+ "icon_popup_view_setup.png"
    property string iconDropDownList: iconsGenericPath+ "icon_job_activate.png"

    property string pinLockedIcon:iconsCustomIsuPath + "Icon_SK_Pin_Locked.png"
    property string pinUnlockedIcon:iconsCustomIsuPath + "Icon_SK_Pin_Unlocked.png"

    property string eventIcon: iconsCustomIsuPath + "Icon_SK_Event.png"

    property string keepResultsIconPath: iconsCustomIsuPath + "Icon_Fn_Powermeter_Keep_Results.png"

    property string tabsIconsBasePath: iconsCustomIsuPath + ""

    property string iconHideOverlay: iconsPath + "report/overlay.png"
    property string iconMenuArrow: iconsPath + "report/SmallArrow.png"
    property string iconMenuUpArrow: iconsPath + "report/up_arrow.png"
    property string iconMenuDownArrow: iconsPath + "report/down_arrow.png"
    property string iconMenuLeftArrow: iconsPath + "report/left_arrow.png"
    property string iconMenuRightArrow: iconsPath + "report/right_arrow.png"

    property string iconMenuScrollDown: iconsGenericPath + "icon_collapse_down.png"
    
    property string iconMenu3Dots: iconsGenericPath + "Icon_3Dots.png"

    property string dragVerticalImg: iconsGenericPath + "drag-vertical.png"
    property string qrCodeImg: iconsGenericPath + "qr-code.png"

    // Icons for zoom buttons
    property string zoomInBtnImg: iconsCustomIsuPath + "zoom-in.png"
    property string zoomOutBtnImg: iconsCustomIsuPath + "zoom-out.png"
    property string zoomAutoBtnImg: iconsCustomIsuPath + "zoom-auto.png"

    // Icons for cursors lock
    property string cursorsLockedBtnImg: iconsGenericPath + "Icon_CursorsLocked.png"
    property string cursorsLockedConnectionBtnImg: iconsGenericPath + "Icon_CursorsLockedConnection.png"
    property string cursorsUnlockedBtnImg: iconsGenericPath + "Icon_CursorsUnlocked.png"
    property string cursorASelectedImg: iconsGenericPath + "Icon_CursorASelected.png"
    property string cursorABoxImg: iconsGenericPath + "Icon_CursorABox.png"
    property string cursorBSelectedImg: iconsGenericPath + "Icon_CursorBSelected.png"
    property string cursorBBoxImg: iconsGenericPath + "Icon_CursorBBox.png"

    // SOURCE DWDM icons
    property string sourceDwdmCancelBtnImg: iconsGenericPath + "Wizard_Icon_Clear.png"
    property string sourceDwdmEnterBtnImg: iconsGenericPath + "Wizard_Icon_Ok.png"

    property string indicatorLeft: iconsCustomIsuPath + "left-indicator.png"
    property string indicatorRight: iconsCustomIsuPath + "right-indicator.png"

    // fix images
    property string fixDeviceNotPresentImage: ""
    property string fixDeviceMtsBigImage: iconsPath + "fcomp/fix_syn_mts_big.png"
    property string fixDeviceMtsImage: iconsPath + "fcomp/fix_syn_mts.png"
    property string fixDeviceMtsInvisibleImage: iconsPath + "fcomp/fix_syn_mts_invisible.png"
    property string fixIconFail: iconsCustomIsuPath + "Dialog_Icon_Fail.png"
    property string fixLinkLeftConnector: iconsPath + "fcomp/leftConnector.png"
    property string fixLinkLeftConnectorLaunch: iconsPath + "fcomp/leftConnectorLaunch.png"
    property string fixLinkLeftConnectorSimpleLaunch: iconsPath + "fcomp/leftConnectorSimpleLaunch.png"
    property string fixLinkLeftConnectorLoopAB: iconsPath + "fcomp/leftConnectorLoopAB.png"
    property string fixLinkLeftConnectorLoopBA: iconsPath + "fcomp/leftConnectorLoopBA.png"
    property string fixLinkRightConnector: iconsPath + "fcomp/rightConnector.png"
    property string fixLinkRightConnectorLaunch: iconsPath + "fcomp/rightConnectorLaunch.png"
    property string fixLinkRightConnectorSimpleLaunch: iconsPath + "fcomp/rightConnectorSimpleLaunch.png"
    property string fixLinkFiberMiddle: iconsPath + "fcomp/fiberMiddle.png"
    property string fixLinkFiberMiddleLaunch: iconsPath + "fcomp/fiberMiddleLaunch.png"
    property string fixLinkFiberMiddleJumper: iconsPath + "fcomp/middleFiberJumper.png"
    property string fixLinkFiberMiddleTerminator: iconsPath + "fcomp/middleFiberTerminator.png"

    property string fixLinkFiberMiddleTerminatorMPO: iconsPath + "fcomp/middleFiberTerminatorMPO.png"
    property string fixLinkFiberMiddleTerminatorMPOWithCap: iconsPath + "fcomp/middleFiberTerminatorMPOWithCap.png"

    property string fixLinkFiberMiddleLoopABBA: iconsPath + "fcomp/middleFiberLoopABBA.png"
    property string fixLinkFiberLine: iconsPath + "fcomp/fiberLine.png"
    property string fixLinkFiberLineLaunch: iconsPath + "fcomp/fiberLineLaunch.png"
    property string fixLinkFiberLineLoopABBA: iconsPath + "fcomp/fiberLineLoopABBA.png"
    property string fixLinkFiberQuarterFiberLoopABBA: iconsPath + "fcomp/querterFiberLoopABBA.png"
    property string fixLinkTestingGreenArrow: iconsPath + "fcomp/fix_syn_green_arrow.png"
    property string fixLinkTestingGreenArrowRight: iconsPath + "fcomp/fix_syn_green_arrow_right.png"
    property string fixLinkTestingTimer: iconsGenericPath + "Busy_Wizard.png"
    property string fixLinkTestingNoTesting: ""
    property string fixRefIconPass: iconsPath + "fcomp/fix_syn_icon_ref_pass.png"
    property string fixRefIconFail: iconsPath + "fcomp/fix_syn_icon_ref_fail.png"
    property string fixFunctionWait: iconsPath + "fcomp/fix_syn_wait.png"
    property string fixFunctionNoDataLink: iconsPath + "fcomp/fix_syn_no_datalink.png"
    property string fixFunctionDataLink: iconsPath + "fcomp/fix_syn_datalink.png"
    property string fixFunctionM2MLinkOn: iconsPath + "fcomp/fix_syn_m2mlink_on.png"
    property string fixFunctionM2MLinkOff: iconsPath + "fcomp/fix_syn_m2mlink_off.png"
    property string fixFunctionPow: iconsPath + "fcomp/fix_syn_pow.png"
    property string fixFunctionSrc: iconsPath + "fcomp/fix_syn_src.png"
    property string fixFunctionOTDR: iconsPath + "fcomp/fix_syn_otdr.png"
    property string fixFunctionORL: iconsPath + "fcomp/fix_syn_orl.png"
    property string fixFunctionFaultFinder: iconsPath + "fcomp/fix_syn_fault_finder.png"
    property string fixFunctionReceive: iconsPath + "fcomp/fix_syn_receive_event.png"
    property string fixFunctionSend: iconsPath + "fcomp/fix_syn_send_event.png"
    property string fixFunctionOEO: iconsPath + "fcomp/fix_syn_oeo.png"
    property string fixFunctionFiberLenth: iconsPath + "fcomp/fix_syn_fiber_length.png"
    property string fixFunctionSave: iconsPath + "fcomp/fix_syn_save.png"
    property string fixFunctionNoFunction: ""
    property string fixLaserImage: iconsPath + "fcomp/fix_syn_laser.png"
    property string fixExchangeSetupIcon: iconsPath + "fcomp/fix_icon_xchange_setup.png"
    property string fixLinkConnected: iconsPath + "fcomp/fix_link_connected.png"
    property string fixLinkDisconnected: iconsPath + "fcomp/fix_link_disconnected.png"
    
    property string trueFiberIcon: iconsIsuPath + "Icon_Fn_True_Fiber_Flat.png"
    property string optiTrakIcon: iconsIsuPath + "Icon_Fn_OptiTrak.png"
    property string backgroundIconImg: "/acterna/storage/look-and-feel/Mts1000/isu/Home_Fn_Icon_Bg.png"
}
