import QtQuick 2.3
import QtQuick.Controls 2.0
import "Viavi_Colors.js" as VColor
import libfexplor 1.0


Rectangle {

    id: globalRect
    property int lineHeight : qmlFileItemList.get_height_screen() >= 600 ? 40: 45
    property int ratioTextPosition: 0 // 0 to 100
    property real mousePosition: 0.0
    property int incr: 0
    property  string focuscolor            : "steelblue"
    property string  focuscolorSelected    : "orange"
    property  string selectedcolor         : "lightsteelblue"
    property  string colorTitle            : VColor.cViaviColorGray
    property string  colorSlider           : VColor.cViaviColorGray

    clip:true
    focus: qmlFileItemList.Focus;

    function selectedItemList( Indexfile )
    {
        qmlFileItemList.update_Selected_Item_List(Indexfile, !qmlFileItemList.File_Item_List[Indexfile].Item_selected );
    }
    
    onFocusChanged: {
        if (focus) {
            listView.positionViewAtIndex(qmlFileItemList.Index, ListView.Center)
            id_animationslider_Vertical_file.start()
        }
    }

    //Key Presse  ********************************************************************
    Keys.onPressed: {
        event.accepted = true
        if (event.key === Qt.Key_Down)
        {
            //console.log(" Key_Down")
            if ( qmlFileItemList.Index < listView.count ) {
                qmlFileItemList.Index =  qmlFileItemList.Index + 1 ;
            }

        }
        else if (event.key === Qt.Key_Up)
        {
            //console.log(" Key_Up")
            if ( qmlFileItemList.Index > 0)
            {
                qmlFileItemList.Index = qmlFileItemList.Index - 1;
            }

        }
        else if (event.key === Qt.Key_Left)
        {
            //console.log(" Key_Left")
            qmlFileItemList.IndexFileMemo  = -1

            if (qmlFileItemList.Focus === true)
            {
                qmlFileItemList.Focus = false ;
                treeModel.dirFocus = true ;
            }
        }
        else if (event.key === Qt.Key_Return)
        {
            //console.log(" Key_Return")
            selectedItemList( listView.realCurrentIndex );
            qmlFileItemList.IndexFileMemo =  listView.realCurrentIndex
        }
        else if (event.key === Qt.Key_Right)
        { // on est dans la list view file et on appuie sur sk right
            //console.log("file  Key_Right")

            if (qmlFileItemList.Index === -1 ) //-1 no_index
            {
                qmlFileItemList.Index = 0;
            }

            selectedItemList(  listView.realCurrentIndex  );

            //premiere fois quand on rentre cote file list
            if ( qmlFileItemList.IndexFileMemo  === -1 )
            {
                qmlFileItemList.IndexFileMemo = listView.realCurrentIndex
            }

            //Si l'index courant est selectionné on  selectionne  la list depuis le dernier IndexFileMemo à l'index courant
            if ( qmlFileItemList.File_Item_List[qmlFileItemList.Index].Item_selected !== false )
            {
                qmlFileItemList.selectMemoFiles()
            }
        }
        else {
            event.accepted = false
        }
    }
    //Key Presse END ********************************************************************

    //DATA COLONNE ********************************************************************
    Component {
        id: id_component_file_list

        Rectangle {

            id : id_rec_component
            height: globalRect.lineHeight
            width : globalRect.width
            property int local_list_index: index
            property int fontpixelSize: 19
            property int width_content:   globalRect.width

            Row {
                id :id_raw
                spacing: 0

                Repeater {
                    model:  qmlFileItemList.Column_Nb
                    id:id_repeater

                    Rectangle {
                        id:id_rec_item_contener
                        width: (!qmlFileItemList.File_Item_List[local_list_index] || !qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index] )?
                                   0: ((globalRect.width * qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index].ratio/100)  )
                        height:  globalRect.lineHeight
                        clip:true

                        Rectangle {
                            id : id_rec_icone
                            //Icone file
                            width:(index == 0)? (alarm_icone.width > 0 ? 60 : 40) : 0 //width icone que dans la premiere colonne
                            visible: (index == 0) ? (true) : (false)//faire apparaitre icone que dans la premiere colonne
                            height:  globalRect.lineHeight
                            anchors.verticalCenter: parent.verticalCenter
                            clip: true
                            color:"transparent"
                            Image {
                                id:alarm_icone
                                anchors.left: parent.left
                                anchors.leftMargin: 5
                                anchors.verticalCenter: parent.verticalCenter
                                source:( qmlFileItemList.File_Item_List[local_list_index] !== undefined && qmlFileItemList.File_Item_List[local_list_index].Alarm_Icone_Index !== "") ? "image://pixmaps/" + qmlFileItemList.File_Item_List[local_list_index].Alarm_Icone_Index : "";
                                smooth:true
                                visible: ( qmlFileItemList.File_Item_List[local_list_index] !== undefined )
                                opacity: qmlFileItemList.File_Item_List[local_list_index].get_alarm_status().length > 0 ? 1: 0
                            }
                            
                            Image {
                                id:icone
                                anchors.right: parent.right
                                anchors.rightMargin:  5
                                anchors.verticalCenter: parent.verticalCenter
                                source:( qmlFileItemList.File_Item_List[local_list_index] !== undefined
                                				&& qmlFileItemList.File_Item_List[local_list_index].File_Icone_Index !== "" ) 
                                			? "image://pixmaps/" + qmlFileItemList.File_Item_List[local_list_index].File_Icone_Index : "";
                                smooth:true
                            }
                        }

                        Rectangle {
                            id:rect_item_txt
                            height:  globalRect.lineHeight

                            anchors.left: id_rec_icone.right
                            anchors.right: id_rec_item_contener.right
                            anchors.leftMargin: (index == 0) ? 5 : 0
                            anchors.rightMargin:(index == 0) ? 7 : 0
                            color: "transparent"
                            clip: true

                            Text {
                                id : fileItemtxt
                                smooth: true
                                text:  (qmlFileItemList.File_Item_List[local_list_index] !== undefined &&  qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index] !== undefined) ?
                                           qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index].item : ""
                                anchors.verticalCenter:  parent.verticalCenter
                                anchors.horizontalCenter: (index == 0)? undefined : parent.horizontalCenter
                                font.family: "DejaVuLGCSansCondensed"
                                font.pixelSize: (!qmlFileItemList.File_Item_List[local_list_index] ||  !qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index]) ?
                                                    0: qmlFileItemList.File_Item_List[local_list_index].ListColumnItem[index].fontSize

                                color:qmlFileItemList.Focus ? ((Item_selected || listView.realCurrentIndex == local_list_index ) ? "white":"black") : ("black")
                            }

                            //ligne verticale
                            Rectangle {
                                id:id_vertical_line
                                anchors.left:  rect_item_txt.left
                                anchors.verticalCenter: rect_item_txt.verticalCenter
                                anchors.rightMargin: 0
                                width: 1
                                height: rect_item_txt.height - 7
                                color:(index == 0 || Item_selected) ? "transparent":selectedcolor
                            }
                        }

                        border.width: 1
                        border.color: (qmlFileItemList.Focus ? (listView.realCurrentIndex == local_list_index ? (Item_selected ? "tomato":"gold" ) : (Item_selected ? "gold":"transparent" )):("transparent"))
                        color: (qmlFileItemList.Focus ? (listView.realCurrentIndex == local_list_index ? (Item_selected ? focuscolorSelected:focuscolor ) : (Item_selected ? selectedcolor:"transparent" )):("transparent"))

                        MouseArea {
                            anchors.fill: parent
                            drag.target: (index == 0) ? fileItemtxt : undefined
                            drag.axis: Drag.XAxis
                            drag.minimumX: (index == 0 && fileItemtxt.width > (rect_item_txt.width - 5) ) ? -( fileItemtxt.width - (rect_item_txt.width/2) ) :0
                            drag.maximumX: 0


                            onClicked: {

                                if ( listView.realCurrentIndex === local_list_index ) {
                                    globalRect.selectedItemList( local_list_index);
                                    qmlFileItemList.IndexFileMemo = local_list_index
                                }
                                else {
                                    qmlFileItemList.Index = local_list_index;
                                }

                                if (qmlFileItemList.Focus === false) {
                                    qmlFileItemList.Focus = true;
                                    treeModel.dirFocus = false ;
                                }
                            }
                        }

                        //ligne entre case
                        Rectangle {
                            anchors.bottom:  id_rec_item_contener.bottom
                            width: parent.width;
                            height: 1
                            opacity: 0.5
                            color:"lightsteelblue"
                        }
                    }
                }
            }

        }
    }
    //FIN DATA COLONNE ********************************************************************


    //TITRE COLONNE ***********************************************************************
    Rectangle {
        id:rec_title
        width: globalRect.width;
        height:  globalRect.lineHeight
        color :   "transparent"
        // clip:true
        border.width: 1
        border.color: "white"
        property int nb_column:0
        property int tmp_ratio:0
        property int bondary:0
        property int bondary_ratio:0
        property int width_limit_max: globalRect.width
        property int width_limit_min: 0
        property string  color_slide_Title:  "white"
        property int pressAndHoldDuration: 1000
        
        Timer {
            id:  pressAndHoldTimer
            interval: parent.pressAndHoldDuration
            running: false
            repeat: false
            onTriggered: {
                qmlFileItemList.reset_defaut_width_column () ;
            }
        }
        
        Row {
            id :id_raw_title
            anchors.right: parent.right
            anchors.left:  parent.left
            Repeater {
                id:id_repeater_title
                model:  qmlFileItemList.Column_Nb
                
                Rectangle {
                    id:id_rec_item_contener_txt_title
                    width:  (!qmlFileItemList.File_Line_Item_Titre ||  !qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index] ) ? 0 :(rec_title.width * qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].ratio/100)   ;
                    height:  globalRect.lineHeight
                    
                    z: qmlFileItemList.Column_Nb - index
                    property  int ratio: (id_vertical_line_title.x/rec_title.width) * 100// en pourcentage 10%
                    property  int pixelSize : 14
                    
                    Rectangle {
                        id:id_rec_txt_title
                        clip:true
                        height:globalRect.lineHeight
                        color: colorTitle//VColor.cViaviColorGray
                        width: parent.width
                        
                        onWidthChanged: {
                            
                            if ( id_txt_title.font.pixelSize !== qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].fontSize) {
                                id_txt_title.font.pixelSize = qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].fontSize
                            }
                            if (id_txt_title.width > 0 && (id_rec_txt_title.width > 0)) {
                                if ( id_txt_title.width > (id_rec_txt_title.width)) {
                                    while (id_txt_title.font.pixelSize >= 12 && id_txt_title.width > (id_rec_txt_title.width ) ) {
                                        id_txt_title.font.pixelSize --;
                                    }
                                }
                                else {
                                    while (id_txt_title.font.pixelSize <= qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].fontSize) {
                                        id_txt_title.font.pixelSize ++;
                                    }
                                }
                            }
                        }
                        
                        //Sort by size
                        Rectangle {
                            anchors.left: parent.left
                            anchors.leftMargin: 0
                            anchors.top: parent.top
                            width: 35
                            height: parent.height
                            visible: index == 0 ? true : false
                            color: "transparent"
                            z: qmlFileItemList.Column_Nb
                            MouseArea {
                                id:idMouseAreaSortFileType
                                anchors.fill: parent
                                onPressed: {
                                    pressAndHoldTimer.start();
                                }
                                onReleased: {
                                    if (pressAndHoldTimer.running ) {
                                        //console.log(" mouse ---------------- sort by type   ");
                                        qmlFileItemList.File_Line_Item_Titre.sort_Item_List(2);//2 sort by type in FO
                                    }
                                    pressAndHoldTimer.stop();
                                }
                            }
                        }
                        
                        Text {
                            id:id_txt_title
                            text: (!qmlFileItemList.File_Line_Item_Titre || !qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index]) ?  "":qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].item
                            anchors.centerIn: parent
                            font.family: "DejaVuLGCSansCondensed"
                            font.pixelSize:  (!qmlFileItemList.File_Line_Item_Titre  ||  !qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index] ) ? 0 :  qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].fontSize
                            color: "white"
                        }
                        
                        MouseArea {
                            id:idMouseAreaTitle
                            anchors.fill: parent
                            onPressed: {
                                //console.log("----onPressed")
                                pressAndHoldTimer.start();
                            }
                            onReleased: {
                                if (pressAndHoldTimer.running ) {
                                    qmlFileItemList.File_Line_Item_Titre.sort_Item_List(index);
                                }

                                pressAndHoldTimer.stop();
                            }
                        }

                        //Triangle dans Tiltre des colonnes indique le sens
                        Triangle {
                            id:id_rec_parent_triangle
                            width: 15
                            height: 15
                            anchors.right: parent.right
                            anchors.rightMargin: 5
                            anchors.top: parent.top
                            color_rectangle: colorTitle
                            color_triangle:"white"
                            visible:( qmlFileItemList.File_Line_Item_Titre.columnVisible === index) ||
                                    (index === 0 && qmlFileItemList.File_Line_Item_Titre.columnVisible  === 2)//sort by type=2 in first column=0
                            sens : qmlFileItemList.File_Line_Item_Titre.direction
                        }

                    }


                    //LINGE SEPARATION VERTICAL TITRE
                    Rectangle {
                        id: id_vertical_line_title
                        width: (index < (qmlFileItemList.Column_Nb -1)) ? 1 : 0
                        height: parent.height
                        color: "white"
                        opacity: 0.5
                        visible: (index < (qmlFileItemList.Column_Nb -1))

                        x:   (! qmlFileItemList.File_Line_Item_Titre || !qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index] ) ? 0 :(rec_title.width * qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].ratio/100) - id_vertical_line_title.width/2   ;

                        Text {
                            id: id_txt_slide_Title
                            text: "<>"
                            verticalAlignment: Text.AlignVCenter
                            anchors.verticalCenter: parent.verticalCenter
                            anchors.horizontalCenter:  parent.horizontalCenter
                            font.family: "DejaVuLGCSansCondensed"
                            font.pixelSize:  15
                            font.bold: true
                            visible: false
                            color: "white"
                        }

                        MouseArea {
                            id:mouseArea_vertical_line
                            anchors.fill: parent
                            anchors.margins: -20
                            drag.target: id_vertical_line_title
                            drag.axis: Drag.XAxis
                            drag.minimumX:  rec_title.width_limit_min
                            drag.maximumX: rec_title.width_limit_max//globalRect.width -  rec_title.bondary // qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].ratio - id_vertical_line_title.width

                            onReleased: {
                                //console.log("onReleased")
                                id_txt_slide_Title.visible = false
                                qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].ratio = ratio
                                qmlFileItemList.set_memo_width_column (index, ratio);
                            }

                            onEntered:  {
                                //console.log("onEntered")
                                id_txt_slide_Title.visible = true
                                rec_title.nb_column = 0
                                rec_title.bondary  = 0
                                rec_title.bondary_ratio = 0

                                while ( rec_title.nb_column < qmlFileItemList.Column_Nb -1 )
                                {

                                    if (  rec_title.nb_column  < index)
                                    {
                                        rec_title.bondary += qmlFileItemList.File_Line_Item_Titre.ListColumnItem[rec_title.nb_column].ratio * rec_title.width/100
                                    }

                                    if (rec_title.nb_column != index)
                                    {

                                        rec_title.bondary_ratio +=  qmlFileItemList.File_Line_Item_Titre.ListColumnItem[rec_title.nb_column].ratio
                                    }
                                    rec_title.nb_column++
                                }

                                rec_title.width_limit_max = (globalRect.width -  rec_title.bondary)

                            }

                            onPositionChanged: {

                                var local_index = 0
                                qmlFileItemList.File_Line_Item_Titre.ListColumnItem[index].ratio  =  ratio
                                while (local_index < listView.count)
                                {
                                    //colonne courante à modifié
                                    qmlFileItemList.File_Item_List[local_index].ListColumnItem[index].ratio = ratio   // ratio en porcentage ex:20 pour 20%

                                    //Derniere colonne à redimentionner
                                    qmlFileItemList.File_Item_List[local_index].ListColumnItem[ qmlFileItemList.Column_Nb -1 ].ratio = 100-ratio - rec_title.bondary_ratio

                                    local_index ++;
                                }


                                //Derniere colonne titre à redimentionner
                                rec_title.tmp_ratio = (100 - ratio - rec_title.bondary_ratio)
                                qmlFileItemList.set_memo_width_column (qmlFileItemList.Column_Nb -1, rec_title.tmp_ratio);
                                qmlFileItemList.File_Line_Item_Titre.ListColumnItem[qmlFileItemList.Column_Nb -1].ratio  =  rec_title.tmp_ratio

                            }

                        }//end MouseArea
                    }
                }

            }
        }
    }
    //TITRE COLONNE ***********************************************************************


    //ListView  *********************************************************************
    Rectangle
    {
        id :rectFileList
        anchors.right: globalRect.right
        anchors.bottom:  globalRect.bottom
        anchors.left: globalRect.left
        anchors.top: rec_title.bottom
        clip: true

        //            Flickable {
        //                id:id_flickable
        //                anchors.fill: parent
        //                flickableDirection: Flickable.HorizontalFlick
        //                boundsBehavior: Flickable.StopAtBounds
        //                contentWidth: listView.width * 1.98;
        //                contentHeight: listView.height
        //               // maximumFlickVelocity: 2000


        ListView {
            id: listView

            /* issue: currentIndex is set to 0 after model reload while qmlFileItemList.Index has a different value */
            /* adding new property to be used instead of currentIndex, new property is not changed by the ListView */
            property int realCurrentIndex: qmlFileItemList.Index

            width: rectFileList.width
            height: rectFileList.height

            //    flickableDirection: Flickable.VerticalFlick

            x:0
            y: 0

            model: qmlFileItemList.File_Item_List
            delegate: id_component_file_list

            boundsBehavior: Flickable.StopAtBounds
            currentIndex: qmlFileItemList.Index
            clip:true
            
            ScrollBar.vertical: ScrollBar {
                id: control
                //not compatible with qt 5.8 from mts5800 if this is a must have need to find better solution 
                //or use this split and use only where available
                //minimumSize : 0.25
                hoverEnabled: true
                //policy: listView.contentHeight >  listView.height * 1.05 ? ScrollBar.AsNeeded : ScrollBar.AlwaysOff
                
                onHoveredChanged: {
                    id_animationslider_Vertical_file.restart()
                }

                onPressedChanged: {
                    if (control.pressed ) {
                        id_animationslider_Vertical_file.stop()
                        control.opacity =1
                    }
                    else {
                        id_animationslider_Vertical_file.restart()
                    }
                }
                
                contentItem: Rectangle {
                    id:id_sliderVertical_list
                    implicitWidth: 9
                    implicitHeight: 100
                    radius: width / 2
                    color: control.pressed ?  focuscolor:colorSlider
                }
            }
            
            onCurrentIndexChanged: {
                id_animationslider_Vertical_file.restart()
            }

            onCountChanged: {
                if ( listView.count <= 0 )  {
                    qmlFileItemList.Focus = false ;
                    treeModel.dirFocus = true ;
                }
                else
                {
                    listView.positionViewAtIndex(qmlFileItemList.Index  ,  ListView.Center);
                }
            }
            
            onMovingVerticallyChanged: {
                if (listView.movingVertically == false) {
                    
                    id_animationslider_Vertical_file.start()
                }
                else if (listView.movingVertically == true) {
                    
                    id_animationslider_Vertical_file.stop()
                    control.opacity =1
                }

            }

            Component.onCompleted: {

                id_animationslider_Vertical_file.restart()
            }

        }

        //            } // END FLICKABLE
    }
    //ListView  FIN *********************************************************************


    //Slider Vertical Animation *********************************************************************
    PropertyAnimation {
        id: id_animationslider_Vertical_file
        target: control
        property: "opacity"
        from: 1
        to: 0
        duration: 3000
        
        easing.type:Easing.InExpo
    }
    
    //wait refresh file list
    Rectangle {
        id: idProgress_TooManyFiles
        property string path_spin_img: "/acterna/storage/look-and-feel/generic/Busy_Wizard.png"

        visible: qmlFileItemList.TooManyFiles
        width: 60
        height: 60
        clip:true
        anchors.centerIn: parent

        Image {
            id: spinImage
            source: idProgress_TooManyFiles.path_spin_img
            anchors.centerIn: parent
        }

        RotationAnimation {
            target: spinImage
            property: "rotation"
            from: 0
            to: 360
            direction: RotationAnimation.Clockwise
            duration: 3000
            loops: Animation.Infinite
            running: qmlFileItemList.TooManyFiles
        }
    }

}




