import QtQuick 2.5

import QtQuick.Layouts 1.2

import "ViaviStyle"

Item {
    property string leftText: 'Left/off'
    property string rightText: 'Right/on'
    property font optionFont: ViaviStyle.layouts.activeTextFont
    property color optionSelected: ViaviStyle.colors.activeColor
    property color optionUnselected: ViaviStyle.colors.disabledItemColor
    property alias buttonOptionSelected: button.buttonOptionSelected
    property alias buttonOptionUnselected: button.buttonOptionUnselected
    property alias isWizardButton: button.isWizardButton
    property alias toggled: button.toggled

    implicitWidth: elements.width
    implicitHeight: elements.height

    height: implicitHeight
    width: implicitWidth

    MouseArea {
        anchors.fill: parent
        onClicked: {
            button.toggle()
        }
    }

    RowLayout {
        id: elements
        anchors.verticalCenter: parent.verticalCenter
        FontMetrics {
            id: metricsHelper
            font: optionFont
        }

        Text {
            id: leftOption
            text: leftText
            font: optionFont
            color: button.toggled ? optionUnselected : optionSelected
        }

        ToggleButton {
            id: button
            Layout.topMargin: ViaviStyle.layouts.smallMargin
            Layout.bottomMargin: ViaviStyle.layouts.smallMargin
            Layout.fillHeight: true
            toggleSize: button.isWizardButton? metricsHelper.height * 4 : metricsHelper.height * 3 //TODO - hardcoded
        }

        Text {
            id: rightOption
            text: rightText
            font: optionFont
            color: button.toggled ? optionSelected : optionUnselected
        }
    }
}
