import QtQuick 2.5
import QtQuick.Layouts 1.2

import "ViaviStyle"

Item {
    property string leftText: 'Left/off'
    property string rightText: 'Right/on'
    property font optionFont: ViaviStyle.layouts.activeTextFont
    property color optionSelected: ViaviStyle.colors.activeColor
    property color optionUnselected: ViaviStyle.colors.disabledItemColor

    property alias button: button
    property alias hasMiddleState: button.hasMiddleState

    property alias isRightDataVisible: button.isRightDataVisible

    implicitWidth: elements.width
    implicitHeight: elements.height


    RowLayout {
        id: elements
        anchors.verticalCenter: parent.verticalCenter
        FontMetrics {
            id: metricsHelper
            font: optionFont
        }

        Text {
            id: leftOption
            text: leftText
            font: optionFont
            color: button.isLeftStateActive ? optionSelected : optionUnselected
        }

        ThreeStateButton {
            id: button
            Layout.topMargin: ViaviStyle.layouts.smallMargin
            Layout.bottomMargin: ViaviStyle.layouts.smallMargin
            Layout.fillHeight: true
            toggleSize: metricsHelper.height * 5

            //Extend the ThreeStateButton mouse area over this entire layout
            mouseArea.anchors.leftMargin: - button.x
            mouseArea.anchors.rightMargin: (button.x + button.width) - elements.width
        }

        Text {
            id: rightOption
            text: rightText
            font: optionFont
            color: button.isRightStateActive ? optionSelected : optionUnselected
        }
    }

}
