import QtQuick 2.3
import QtQuick.Controls 2.0

import "ViaviStyle"

Item{
    id: rootItem
    width: column.width
    height: column.height

    default property alias rowData: rowId.data

    signal clicked

    MouseArea{
        id: mouseAreaId
        anchors.fill: parent

        onClicked:{
            rootItem.clicked()
        }
    }

    Column {
        id: column

        spacing: ViaviStyle.layouts.mediumMargin

        //invisible item to center the row inside the column
        Item{
            height: ViaviStyle.layouts.separatorSize
            width: 1
        }

        Row{
            id:rowId
        }

        HorizontalSeparator{
            anchors.left: parent.left
            anchors.right: parent.right
        }
    }

    Rectangle{
        visible: mouseAreaId.pressed

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }
}
