import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import elf_plugin 1.0
import "ViaviStyle"

Rectangle{
    id: rootId

    anchors.fill: parent

    color: ViaviStyle.colors.pageBackgroundColor

    property bool labelListNotAvailable: project_cfg_labelListDisabled.value || project_cfg_labelsListPath.value === ""
    property bool isOtdrEnterpriseScreen: status_res_otdrMode.value === status_res_otdrMode.enums.ecIsu_Otdr_Mode_Enterprise

    KeyboardUtils { id: keyboardUtils }

    Connections{
        target: functionsTabs_cfg_currentFunction
        function onValueChanged() {
            project_cfg_setupEnabled.value = false
        }
    }

    Connections{
        target: status_res_otdrMode
        function onValueChanged() {
            project_cfg_setupEnabled.value = false
        }
    }

    Flickable{
        id: prjSetupSelection

        contentHeight: prjSetupColumn.height
        contentWidth: parent.width
        boundsBehavior: Flickable.StopAtBounds

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layouts.largeMargin
        anchors.bottom: prjSetupLowerBar.top
        anchors.bottomMargin: ViaviStyle.layouts.largeMargin

        property int rowHeight: height / 7

        Column{
            id: prjSetupColumn
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: ViaviStyle.layouts.veryLargeMargin
            spacing: ViaviStyle.layouts.largeMargin

            Row{
                visible: !isOtdrEnterpriseScreen
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_labelsListLabel.value
                }

                ToggleButtonOption {
                    id: labelsListToggle

                    height: parent.height
                    width: parent.height * 1.3
                    anchors.verticalCenter: parent.verticalCenter

                    optionFont: ViaviStyle.layouts.veryLargeFont
                    optionSelected: ViaviStyle.colors.secondaryInfoColor
                    optionUnselected: ViaviStyle.colors.mainInfoColor
                    buttonOptionSelected: ViaviStyle.colors.secondaryInfoColor
                    buttonOptionUnselected: ViaviStyle.colors.activeColor
                    isWizardButton: true

                    leftText:  ""
                    rightText: toggled  ? project_res_noLabel.value : project_res_yesLabel.value

                    onToggledChanged: project_cfg_labelListDisabled.value = toggled

                }
            }

            Row{
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_labelsSelectedListLabel.value
                }

                WizardEditableText{
                    id: file

                    enabled: !project_cfg_labelListDisabled.value
                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignLeft
                    text: project_cfg_labelsListPath.value

                    source: ViaviStyle.images.iconOpenFile

                    onClicked: {
                        project_act_selectLabelsList.invoke()
                    }
                }
            }


            // Project Name
            Row{
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_projectNameLabel.value
                }

                WizardEditableText{
                    id: projectName

                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignLeft

                    Component.onCompleted: projectName.text = project_cfg_projectName.value

                    Connections{
                        target: project_cfg_projectName
                        function onValueChanged() {
                        	projectName.text = project_cfg_projectName.value
                        }
                    }

                    function keyAccepted () {
                        text = keyboardAlphaPopup.textField
                        project_cfg_projectName.value = text
                        keyboardAlphaPopup.close()

                        keyboardAlphaPopup.accepted.disconnect(keyAccepted)
                        keyboardAlphaPopup.canceled.disconnect(keyCanceld)
                    }

                    function keyCanceld() {
                        keyboardAlphaPopup.close()

                        keyboardAlphaPopup.accepted.disconnect(keyAccepted)
                        keyboardAlphaPopup.canceled.disconnect(keyCanceld)
                    }

                    onClicked: {
                        keyboardAlphaPopup.accepted.connect(keyAccepted)
                        keyboardAlphaPopup.canceled.connect(keyCanceld)

                        keyboardAlphaPopup.initialText = text
                        keyboardAlphaPopup.open()
                    }
                }
            }


            Row{
                visible: !project_cfg_labelListDisabled.value
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_panelStructureLabel.value
                }

                WizardComboBox{
                    id: panelStructureComboBox

                    width: parent.width * 0.75
                    height: parent.height

                    model: panelStructureModel
                    textRole: 'text'

                    onCurrentIndexChanged: project_cfg_panelStructure.value = panelStructureModel.get(currentIndex).value

                    ListModel {
                        id: panelStructureModel
                        Component.onCompleted: {
                            append({"text": project_res_multifiberConnectorsLabel.value, "value": project_cfg_panelStructure.enums.epsMultiConnectors} )
                            //   append({"text": project_res_multifiberCassettesLabel.value, "value": project_cfg_panelStructure.enums.epsMultiCassettes} )
                            append({"text": project_res_simplexFiberLabel.value, "value": project_cfg_panelStructure.enums.epsSimplex} )

                            var newIndex = -1
                            for(var index = 0; index < panelStructureModel.count; ++index){
                                if( panelStructureModel.get(index).value === project_cfg_panelStructure.value){
                                    newIndex = index
                                }
                            }
                            panelStructureComboBox.currentIndex = newIndex
                        }
                    }
                }
            }


            Row{
                visible: project_cfg_labelListDisabled.value
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter
                    text: project_res_nrOfFibersLabel.value
                }

                WizardEditableText{
                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignHCenter
                    text: project_cfg_nrOfFibers.value

                    onClicked: {
                        keyboard.currentKeyboardElf = project_cfg_nrOfFibers
                        keyboard.initialText = project_cfg_nrOfFibers.value
                        keyboardPopup.open()
                    }
                }
            }

            Row{
                visible: project_cfg_labelListDisabled.value
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter
                    text: project_res_startFiberLabel.value
                }

                WizardEditableText{
                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignHCenter
                    text: project_cfg_startFiber.value

                    onClicked: {
                        keyboard.currentKeyboardElf = project_cfg_startFiber
                        keyboard.initialText = project_cfg_startFiber.value
                        keyboardPopup.open()
                    }
                }
            }


            Row{
                visible: project_cfg_panelStructure.value === project_cfg_panelStructure.enums.epsMultiCassettes

                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter
                    text: project_res_nbFibersPerCassetteLabel.value
                }

                WizardEditableText{
                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignHCenter
                    text: project_cfg_nrOfFibersPerCassette.value

                    onClicked: {
                        keyboard.currentKeyboardElf = project_cfg_nrOfFibersPerCassette
                        keyboard.initialText = project_cfg_nrOfFibersPerCassette.value
                        keyboardPopup.open()
                    }
                }
            }


            Row{
                visible: project_cfg_panelStructure.value === project_cfg_panelStructure.enums.epsMultiCassettes
                         && rootId.labelListNotAvailable

                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_nbCassettesLabel.value
                }

                WizardEditableText{
                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignHCenter
                    text: project_cfg_nrOfCassettes.value

                    onClicked: {
                        keyboard.currentKeyboardElf = project_cfg_nrOfCassettes
                        keyboard.initialText = project_cfg_nrOfCassettes.value
                        keyboardPopup.open()
                    }
                }
            }


            Row{
                visible: project_cfg_panelStructure.value === project_cfg_panelStructure.enums.epsMultiConnectors
                         && !project_cfg_labelListDisabled.value

                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_connectorTypeLabel.value
                }

                WizardComboBox{
                    id: connectorTypeComboBox

                    width: parent.width * 0.75
                    height: parent.height

                    model: connectorTypeModel
                    textRole: 'text'

                    onCurrentIndexChanged: project_cfg_fiberConnectorType.value = connectorTypeModel.get(currentIndex).value

                    ListModel {
                        id: connectorTypeModel
                        Component.onCompleted: {
                            append({"text": project_res_connectorDuplexLabel.value, "value": project_cfg_fiberConnectorType.enums.efcDuplex} )
                            append({"text": project_res_connector08_12Label.value, "value": project_cfg_fiberConnectorType.enums.efcMPOx08_12} )
                            append({"text": project_res_connector12_12Label.value, "value": project_cfg_fiberConnectorType.enums.efcMPOx12_12} )
                            append({"text": project_res_connector20_24Label.value, "value": project_cfg_fiberConnectorType.enums.efcMPOx20_24} )
                            append({"text": project_res_connector24_24Label.value, "value": project_cfg_fiberConnectorType.enums.efcMPOx24_24} )

                            var newIndex = -1
                            for(var index = 0 ; index < connectorTypeModel.count; ++index){
                                if( connectorTypeModel.get(index).value === project_cfg_fiberConnectorType.value){
                                    newIndex = index
                                }
                            }
                            connectorTypeComboBox.currentIndex = newIndex
                        }
                    }
                }
            }

            // Contractor ID
            Row{
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_contractorIDLabel.value
                }

                WizardEditableText{
                    id: contractorID

                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignLeft

                    Component.onCompleted: contractorID.text = project_cfg_contractorID.value

                    Connections{
                        target: project_cfg_contractorID
                        function onValueChanged() {
                        	contractorID.text = project_cfg_contractorID.value
                        }
                    }

                    onClicked: {
                        project_act_keyboardSetContractorID.invoke()
                    }
                }
            }

            // SubContractor ID
            Row{
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_subContractorIDLabel.value
                }

                WizardEditableText{
                    id: subContractorID

                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignLeft

                    Component.onCompleted: subContractorID.text = project_cfg_subContractorID.value

                    Connections{
                        target: project_cfg_subContractorID
                        function onValueChanged() {
                        	subContractorID.text = project_cfg_subContractorID.value
                        }
                    }

                    onClicked: {
                        project_act_keyboardSetSubContractorID.invoke()
                    }
                }
            }

            // Engineer ID
            Row{
                anchors.left: parent.left
                anchors.right: parent.right
                height: prjSetupSelection.rowHeight

                spacing: ViaviStyle.layouts.mediumMargin

                Text{
                    width: parent.width * 0.25
                    height: parent.height

                    font: ViaviStyle.layouts.veryLargeFont
                    verticalAlignment: Text.AlignVCenter

                    text: project_res_engineerIDLabel.value
                }

                WizardEditableText{
                    id: engineerID

                    width: parent.width * 0.75
                    height: parent.height

                    font: ViaviStyle.layouts.tableFont
                    textHorizontalAlignment: Text.AlignLeft

                    Component.onCompleted: engineerID.text = project_cfg_engineerID.value

                    Connections{
                        target: project_cfg_engineerID
                        function onValueChanged() {
                        	engineerID.text = project_cfg_engineerID.value
                        }
                    }

                    onClicked: {
                        project_act_keyboardSetEngineerID.invoke()
                    }
                }
            }
        }
    }

    Rectangle {
        id: prjSetupLowerBar
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: parent.bottom

        height: ViaviStyle.layouts.buttonHeight * 1.6

        RowLayout {
            anchors.fill: parent
            spacing: ViaviStyle.layouts.borderSize * 2

            Rectangle{

                Layout.fillHeight: true
                Layout.fillWidth: true
                color: ViaviStyle.colors.secondaryInfoColor

                Text{
                    anchors.left: parent.left
                    anchors.leftMargin: ViaviStyle.layouts.veryLargeMargin
                    verticalAlignment: Text.AlignVCenter
                    horizontalAlignment: Text.AlignLeft

                    width: parent.width
                    height: parent.height
                    font: ViaviStyle.layouts.veryLargeFont
                    color: ViaviStyle.colors.activeItemTextColor
                    text: project_cfg_projectName.value + project_cfg_projectFileExtension.value
                }
            }


            WizardImageButton{
                id: openPage
                text: project_res_openProjectLabel.value.toUpperCase()

                width: height * 1.5
                height: parent.height
                source: ViaviStyle.images.iconOpenFile
                onClicked:{
                    project_act_loadProject.invoke()
                }
            }

            WizardButton{
                text: project_res_createProjectLabel.value.toUpperCase()

                property bool labelListSetupValid: project_cfg_labelListDisabled.value ? true :
                                  (project_cfg_labelsListPath.value && project_cfg_labelsListPath.value.length > 0)
                enabled: labelListSetupValid && project_cfg_projectName.value && project_cfg_projectName.value.length > 0

                width: height * 1.5
                height: parent.height

                onClicked:{
                    project_act_createProject.invoke()
                }
            }

            WizardButton{
                id: closePage
                text: project_res_closeProjectLabel.value.toUpperCase()

                width: height * 1.5
                height: parent.height

                onClicked:{
                    project_cfg_setupEnabled.value = false
                }
            }
        }
    }

    Popup{
        id: keyboardAlphaPopup

        width: fiberMainPage.width
        height: fiberMainPage.height

        property alias textField: keyboardAlpha.textField
        property alias initialText: keyboardAlpha.initialText

        //property var translatedPosition: container.mapFromItem(fiberMainPage, 0, 0)
        x: 0
        y: 0
        parent: fiberMainPage

        modal: true

        closePolicy: Popup.NoAutoClose

        background: Rectangle{

            anchors.fill: parent

            color: ViaviStyle.colors.transparentBackgroundColor
        }

        signal accepted()
        signal canceled()

        contentItem: Item{

            anchors.fill: parent

            KeyboardAlpha{
                id: keyboardAlpha

                inputTextMaxLength: 60
                onAccepted: keyboardAlphaPopup.accepted()
                onCanceled: keyboardAlphaPopup.canceled()


            }
        }
    }

    Popup{
        id: keyboardPopup

        width: fiberMainPage.width
        height: fiberMainPage.height

        //property var translatedPosition: container.mapFromItem(fiberMainPage, 0, 0)
        x: 0
        y: 0
        parent: fiberMainPage

        modal: true

        closePolicy: Popup.NoAutoClose

        background: Rectangle{

            anchors.fill: parent

            color: ViaviStyle.colors.transparentBackgroundColor
        }

        contentItem: Item{

            anchors.fill: parent

            KeyboardNumerical{
                id: keyboard
                //   visible: false
                property ElfData currentKeyboardElf

                onAccepted: {
                    if(currentKeyboardElf){
                        currentKeyboardElf.value = textField
                    }

                    keyboardPopup.close()
                }

                onCanceled: keyboardPopup.close()

            }
        }
    }



}

