import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import "ViaviStyle"

//TODO: modifiy Dialog such that it can be used as base for this element, instead of Popup
Popup {
    id: popupBusy
    anchors.centerIn: parent

//    property alias titleText:
    property alias text: mainText.text
    property alias extraText: extraText.text
    property alias cancelText: interruptButton.text
    property alias rectangleWidth: contentPopUp.width
    property alias rectangleHeight: contentPopUp.height
    property alias interruptible: interruptButton.visible

    signal interrupt

    background: Rectangle { color: ViaviStyle.colors.transparentBackgroundColor }

    Rectangle {
        id: contentPopUp

        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter

        color: ViaviStyle.colors.contentBackgroundColor

        Row{
            id: mainContent

            spacing: ViaviStyle.layouts.largeMargin

            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter

            InprogressIcon {
                id: icon
            }

            Text {
                id: mainText

                width: contentWidth
                height: parent.height

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layouts.activeTextFont
                text: 'Do not forget to fill in text'
                wrapMode: Text.WordWrap
            }
        }

        Text {
            id: extraText
            anchors.top: mainContent.bottom
            anchors.horizontalCenter: parent.horizontalCenter

            anchors.topMargin: ViaviStyle.layouts.largeMargin

            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            //text: 'Extra text, would it be needed?'

            color: ViaviStyle.colors.secondaryInfoColor
            font: ViaviStyle.layouts.infoTextFont
        }

        FiberButton {
            id: interruptButton
            visible: false
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.margins: ViaviStyle.layouts.mediumMargin
            height: ViaviStyle.layouts.buttonHeight
            width: ViaviStyle.layouts.buttonHeight * 3
            text: 'Cancel'

            onClicked: {
                interrupt()
            }
        }
    }
}
