import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor

Rectangle {
	id: popUpWarning
	
	width: 650
	height: 250
	clip: true
	
	property string warningType: "" // Error/Warning/Info/Progress
	
	property string path_img: ""
	
    property string warningText: ""
    property string warningSubText: ""
    property int warningTextPxlSize: 25
    property int warningSubTextPxlSize: 20
    property string btnLText: ""
    property string btnRText: ""
    
    property string clickToExitText: ""
    
    property bool inProgress: false
    
    property string pathErrorIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Error.png"
    property string pathWarningIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Warning.png"
    property string pathInfoIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Info.png"
    property string path_spin_img: "/acterna/storage/look-and-feel/generic/Busy_Wizard.png"
    
    property int numberOfButtons: 0
    
    signal btnLClicked()
    signal btnRClicked()
    
    signal warningClicked()

	anchors.centerIn: parent
		
	color: VColor.cViaviColorLightGray2
	border.width: 2
	border.color: VColor.cViaviColorDarkGray

	MouseArea {
		id: warningMouseArea
		anchors.fill: parent
        onClicked: warningClicked()
	}
	
	Image {
		id: infoIcon
		visible: popUpWarning.warningType == "Info"
		source: pathInfoIcon
		
		anchors.top: popUpWarning.top
		anchors.topMargin: 60
		
		anchors.left: popUpWarning.left
		anchors.leftMargin: 40

	}
	
	Image {
		id: warningIcon
		visible: popUpWarning.warningType == "Warning"
		source: pathWarningIcon
		
		anchors.top: popUpWarning.top
		anchors.topMargin: 60
		
		anchors.left: popUpWarning.left
		anchors.leftMargin: 40

	}
	
	Image {
		id: errorIcon
		visible: popUpWarning.warningType == "Error"
		source: pathErrorIcon
		
		anchors.top: popUpWarning.top
		anchors.topMargin: 60
		
		anchors.left: popUpWarning.left
		anchors.leftMargin: 40

	}
	
	Image {
		id: spinImage
		visible: popUpWarning.warningType == "Progress"
		source: path_spin_img
		
		anchors.top: popUpWarning.top
		anchors.topMargin: 60
		
		anchors.left: popUpWarning.left
		anchors.leftMargin: 40
		}
	
	RotationAnimation {
		 target: spinImage
		 property: "rotation"
		 from: 0
		 to: 360
		 direction: RotationAnimation.Clockwise
		 duration: 3000
		 loops: Animation.Infinite
		 running: inProgress
	}
	
	Column {
	
		anchors.verticalCenter: warningIcon.verticalCenter
		anchors.left: warningIcon.right
		anchors.leftMargin: 20
		anchors.right: popUpWarning.right
		anchors.rightMargin: 10
	
		Text {
			id: mainText
			width: parent.width
		
			wrapMode: Text.Wrap
			text: warningText
			font.pixelSize: warningTextPxlSize
		}
		
		Text {
			id: subText
			visible: warningSubText != ""
			x: 10
			width: parent.width			
		
			wrapMode: Text.Wrap
			text: warningSubText
			font.pixelSize: warningSubTextPxlSize
		}
		
	}
	
	Rectangle {
		id: btnL 
		visible: numberOfButtons == 2
		color: btnLMouseArea.pressed ? VColor.cViaviColorLightBlue : "white"
		anchors.right: btnR.left
		anchors.rightMargin: 10
		anchors.bottom: popUpWarning.bottom
		anchors.bottomMargin: 10
		
		width: 140
		height: 70
			
		Text {
			text: btnLText
			anchors.centerIn: parent
			font.pixelSize: 20
			color: VColor.cViaviColorBlack
		}
		
		MouseArea{
			id: btnLMouseArea
			anchors.fill: parent
			onClicked: btnLClicked()
		}
	}
	
	Rectangle {
		id: btnR 
		visible: numberOfButtons >= 1
		color: btnRMouseArea.pressed ? VColor.cViaviColorLightBlue : "white"
		anchors.right: popUpWarning.right
		anchors.rightMargin: 10
		anchors.bottom: popUpWarning.bottom
		anchors.bottomMargin: 10
		
		width: 140
		height: 70
			
		
		MouseArea{
			id: btnRMouseArea
			anchors.fill: parent
			onClicked: btnRClicked()
		}

		Text {
			text: btnRText
			anchors.centerIn: parent
			font.pixelSize: 20
			color: VColor.cViaviColorBlack
		}
	}
	
	Text {
		id: exitText
		visible: numberOfButtons == 0
		
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 10
		anchors.left: parent.left
		anchors.leftMargin: 10
		
		font.pixelSize: 18
		color: VColor.cViaviColorBlack
		
		text: clickToExitText
	}
	

}
