import QtQuick 2.5
import "ViaviStyle"

KeyboardAlpha{

    fullLevel1: keyboard_res_type.value === keyboard_res_keyboardType.enums.ecComplete_Keyboard
    fullLevel2: keyboard_res_type.value === keyboard_res_keyboardType.enums.ecComplete_Keyboard

    titleDescription: keyboard_res_titleDescription.value

    systemLanguage: keyboard_cfg_keyboardLayout.valueString

    titleText: keyboard_res_title.value
    hasTitleAction: keyboard_res_hasTitleCallback.value
    onTitleClicked: {
        keyboard_act_handleTitleCallback.invoke()
    }

    inputTextMaxLength: keyboard_res_maxSize.value

    onInputTextChanged: keyboard_cfg_text.value = newText

    initialText: keyboard_res_initText.value

    onCanceled: {
        keyboard_act_handleCancelKey.invoke()
    }

    onAccepted: {
        keyboard_act_handleEnterKey.invoke()
    }

    onConfigurableButtonClicked:{
       keyboard_act_handleMeasureKey.invoke()
    }

    onDefaultPressed: {
       textField = keyboard_res_defaultText.value
    }

    hasDefaultButton: keyboard_res_hasDefaultButton.value

    hasSecondPage: keyboard_res_has2ndPage.value

    ListModel{
        id: legacyModel
    }

    secondPageKeysModel: legacyModel

    function updateModel(){
        legacyModel.clear()
        for(var index = 0; index < keyboard_res_buttons_stringARRAY.valueCount; ++index){
           legacyModel.append({"name": keyboard_res_buttons_stringARRAY.at(index)})
        }
    }

    Component.onCompleted: updateModel()

    Connections{
        target: keyboard_res_buttons_stringARRAY
        function onValueChanged() {
        	updateModel()
        }
    }

}
