import QtQuick 2.5
import "ViaviStyle"


Rectangle {
    id: buttonRectangle

    property alias  buttonWidth             : buttonRectangle.width
    property alias  buttonHeight            : buttonRectangle.height
    property alias  buttonBackgroundColor   : buttonRectangle.color
    property alias  buttonLabelVisible      : buttonTextLabel.visible

    /* button label: always make sure to set this values */
    property string buttonLabel             : ""
    property int    buttonType              : keyboardUtils.buttonTypeAlpha
    property bool   buttonPressed           : false
    property bool   buttonEnabled           : true


    width: keyboardUtils.buttonWidthAlphaKeyb
    height: keyboardUtils.buttonHeightAlphaKeyb

    border.color: ViaviStyle.colors.alternativeBackgroundColor
    border.width: ViaviStyle.layouts.keyboardButtonMargin

    color: !buttonEnabled ? ViaviStyle.colors.alternativeBackgroundColor :
            buttonPressed ? ViaviStyle.colors.activeColor : ViaviStyle.colors.contentBackgroundColor


    Text {
        id: buttonTextLabel

        visible: buttonEnabled

        anchors.centerIn: parent

        text: buttonLabel

        font: ViaviStyle.layouts.titleTextFont

        color: buttonPressed ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
    }

    MouseArea {
        id: buttonMouseArea

        anchors.fill: parent

        enabled: buttonEnabled

        onPressed: {
            buttonRectangle.buttonPressed = true
        }

        onReleased: {
            buttonRectangle.buttonPressed = false

            if ( buttonType == keyboardUtils.buttonTypeAlpha ||
                    buttonType == keyboardUtils.buttonTypeNumerical)
            {
                charButtonClicked( buttonLabel )
            }
            else if ( buttonType == keyboardUtils.buttonTypeCustom )
            {
                customButtonClicked( buttonLabel )
            }
            else if ( buttonType == keyboardUtils.buttonType2ndPage )
            {
                extraButtonClicked( buttonLabel )
            }
        }
    }
}



