import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Rectangle {
    id: keyViewPopup
    color: VColor.cViaviColorLogoPurple
    //color: VColor.cViaviColorLightBlue

    focus: true

    // TBD - Animate appearance of the pop-up
    //Behavior on height { PropertyAnimation { duration: 300 } } //easing.type: Easing.OutElastic;

    //property int heightButton: 78
    //property int heightButton: (keyViewPopup.height - 8) / 3 // value to use if only 3 buttons for File/Setup/Results
    property int heightButton: (keyViewPopup.height - 11) / 4 // 4 keys including Cancel 
    property int buttonMargin: 12
    property int cancelZoneWidth: 40

    MouseArea {
        // Allows exiting the Pop-up without pressing a specific button (anywhere else == close)
        // (No need for a row to hold a specific cancel button)
        anchors.fill: parent
        onClicked: {
            View_Popup.close_Popup();
            }
        }

    Column {
        id: isu_Popup_Col
        spacing: 0
        anchors.left: parent.left
        anchors.leftMargin: 3
        anchors.top: parent.top
        anchors.topMargin: 3
        width: parent.width - cancelZoneWidth

        Rectangle {
            id: isuFile

            width: parent.width
            height: heightButton
            color: mouse_Area_File.containsMouse ?  VColor.cViaviColorLightBlue : VColor.cViaviColorGray //"transparent"

            anchors.horizontalCenter: parent.horizontalCenter

            Image { // The icon metaphor
                id: fileMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_file.png"
                }
                
            Text {
                id: fileTitle
                anchors.top: parent.top
                anchors.topMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter

                color: VColor.cViaviColorWhite
                text: qsTr("File")
                font.bold: true
                font.pointSize: 11
                font.family: "DejaVu LGC Sans"
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_File
                anchors.fill: parent
                onClicked: { View_Popup.keyFile(); }
                }
            }
            
        Rectangle { // Separator
            color: VColor.cViaviColorLightBlue
            anchors.horizontalCenter: parent.horizontalCenter
            width: parent.width - 10
            height: 1
            }

        Rectangle {
            id: isuSetup
            
            width: parent.width
            height: heightButton
            color: mouse_Area_Setup.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorGray
            anchors.horizontalCenter: parent.horizontalCenter
            
            Image { // The icon metaphor
                id: setupMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_setup.png"
                }
                
            Text {
                id: setupTitle
                anchors.top: parent.top
                anchors.topMargin: buttonMargin
                anchors.fill: parent
                
                color: VColor.cViaviColorWhite
                text: qsTr("Setup")
                font.bold: true
                font.pointSize: 11
                font.family: "DejaVu LGC Sans"
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_Setup
                anchors.fill: parent
                onClicked: { View_Popup.keySetup(); }
                }
            }
            
       Rectangle { // Separator
            color: VColor.cViaviColorLightBlue
            anchors.horizontalCenter: parent.horizontalCenter
            width: parent.width - 10
            height: 1
            }

        Rectangle {
            id: isuResults
            
            width: parent.width
            height: heightButton
            color: mouse_Area_Results.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorGray
            anchors.horizontalCenter: parent.horizontalCenter

            Image { // The icon metaphor
                id: resultsMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
                }
                
            Text {
                id: resultsTitle
                anchors.top: parent.top
                anchors.topMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter
                
                color: VColor.cViaviColorWhite
                text: qsTr("Results")
                font.bold: true
                font.family: "DejaVu LGC Sans"
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_Results
                anchors.fill: parent
                onClicked: { View_Popup.keyResults(); }
                onPressAndHold: { View_Popup.keyResultsLong(); }
                }
            }

        Rectangle { // Separator
            color: VColor.cViaviColorLightBlue
            anchors.horizontalCenter: parent.horizontalCenter
            width: parent.width - 10
            height: 1
            }

        Rectangle {
            id: isuCancel

            width: parent.width
            height: heightButton
            color: mouse_Area_Setup.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorGray
            anchors.horizontalCenter: parent.horizontalCenter

            Image { // The icon metaphor
                id: cancelMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_cancel.png"
                }

            Text {
                id: cancelTitle
                anchors.top: parent.top
                anchors.topMargin: buttonMargin
                anchors.horizontalCenter: parent.horizontalCenter

                color: VColor.cViaviColorWhite
                text: qsTr("Cancel")
                font.bold: true
                font.family: "DejaVu LGC Sans"
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Cancel
                anchors.fill: parent
                onClicked: { View_Popup.keyCancel(); }
                }
            }

        } //end of Results / Setup / File column

    Image {
        id: cancelPopup
//        anchors.bottom: parent.bottom // if we want to place the cancel icon near the bottom
//        anchors.bottomMargin: 10
        anchors.top: parent.top
        anchors.topMargin: 10
        anchors.right: parent.right
        anchors.rightMargin: 5
        height: 24
        fillMode: Image.PreserveAspectFit
        source:"/acterna/storage/look-and-feel/generic/icon_popup_view_cancel.png"
        }

    } // end Rectangle

