import QtQuick 2.12
import QtQml 2.12
import QtQuick.Controls 2.2

import "Viavi_Colors.js" as VColor
import libjobmgr 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: backgroundJobMgr
    //color: VColor.cViaviColorLogoPurple
    //color: VColor.cViaviColorLightBlue
    color: VColor.cViaviRealBlack

    focus: true

    // TBD - Animate appearance of the pop-up
    //Behavior on height { PropertyAnimation { duration: 300 } } //easing.type: Easing.OutElastic;

    // Button parameters
    property int nbButton: 6
    property int nbSpacing: nbButton - 1
    property int spacingWidth: 5
    property int buttonWidth: ( backgroundJobMgr.width - 2 * marginWidth - nbSpacing * spacingWidth ) / nbButton
    property int buttonHeight: ijmIsDisplayed ? 55 : 60
    
    property int marginWidth: 16
    property int marginHeaderWidth: 12
    
    property int jobState : Job_Mgr.job_Mgr_State

    property bool isJobInfoPanelOn : true
    property bool isJobTestPlanPanelOn : true
    property bool isJobTestReportsPanelOn : true

    property int lineHeight: 38
    property int lineSpacing: 2
    
    property int savedWholeJobY: 0
    
    property bool jobErrorShown: false; // Warning dialog for incompatible Jobs

    property bool ijmIsDisplayed: true

    Component.onCompleted: {
    	Job_Mgr.testPlanModel.modelReset.connect(setContentToSavedPos);
    	Job_Mgr.jobInfoModel.modelReset.connect(setContentToSavedPos);
    	Job_Mgr.testReportsModel.modelReset.connect(setContentToSavedPos);
    	
    	Job_Mgr.jobInfoModel.modelReset.connect(closeKeyBoard);
    }
    
    function openKeyBoard(title, initialText) {
        keyboard.titleText = title;
        keyboard.initialText = initialText;

        keyboard.visible = true;
    }
    
    function closeKeyBoard() {
    	keyboard.titleText = "";
        keyboard.initialText = "";

        keyboard.visible = false;
        keyboard.editText.disconnect();
    }
    
    function openFileExplorer() {
        Job_Mgr.miniFileExplorer.Update_File_List();
        
    	miniFileExplorer.visible = true;
    }
    
    function openSkipWindow( index ) {
      jobSkipTest.personnalComment = "";
      jobSkipTest.autoComment = "";
      jobSkipTest.currentCode = -1;
      
      jobSkipTest.indexTestPlan = index;
      jobSkipTest.visible = true;
    }
    
    function setContentToSavedPos() {
        theWholeJob.contentY = savedWholeJobY;           
    }
    
    function resetSavedPos() {
        savedWholeJobY = 0;
        theWholeJob.contentY = savedWholeJobY;           
    }
    
    function saveContentPos() {
        savedWholeJobY = theWholeJob.contentY;           
    }
     
    function filterTestReports( filter ) {
        saveContentPos();
        Job_Mgr.Refresh_Test_Reports_Model_With_filter( filter );
    }
    
    JobManagerTranslation {
      id: jobManagerTranslation
      
      Component.onCompleted: {
         // Update connection
         Job_Mgr.updateAllTraduction.connect( jobManagerTranslation.traductionChanged )
      }
    }
   

    Row {
        id: isu_Job_Mgr_Buttons_Row
        opacity: ( ijmIsDisplayed ) ? 0 : 1

        anchors.top: parent.top
        anchors.topMargin: 10
        anchors.left : parent.left
        anchors.leftMargin: marginWidth
        anchors.right : parent.left
        anchors.rightMargin: marginWidth
        
        spacing: spacingWidth
        height: buttonHeight
        
        enabled: !keyboard.visible && !jobSkipTest.visible && !continuityCheckItem.visible && !manualStepItem.visible && !popupLoadJobJson.visible

        Rectangle {
            id: loadJobButton
            width: buttonWidth
            height: buttonHeight
            color: mouse_Area_Load_Job.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
            anchors.verticalCenter: parent.verticalCenter
            opacity: ( ijmIsDisplayed ) ? 0 : 1

            Image { // The icon metaphor
                id: loadJobMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 28
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_job_load.png"
                }

            Text {
                id: loadJobTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobLoad
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Load_Job
                anchors.fill: parent
                onClicked: {
                    console.log("[Qml] Opening Mini-explorer for Load Button" );
                    openFileExplorer();
                }
            }
        }

        Rectangle {
            id: activateJobButton
            width: buttonWidth
            height: buttonHeight
            opacity: ( ijmIsDisplayed ) ? 0 : ( mouse_Area_Activate.containsMouse ) ? 0.5 : 1
            color: (jobState === 0) ? VColor.cViaviColorLogoPurple : VColor.cViaviColorLightBlue
            anchors.verticalCenter: parent.verticalCenter

            Image { // The icon metaphor
                id: activateMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 28
                fillMode: Image.PreserveAspectFit
                source: (jobState === 0) ? "/acterna/storage/look-and-feel/generic/icon_job_activate.png" : "/acterna/storage/look-and-feel/generic/icon_job_pause.png"
                }

            Text {
                id: activateJobTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: (jobState === 0) ? jobManagerTranslation.txtJobStart : jobManagerTranslation.txtJobStop
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Activate
                anchors.fill: parent
                onClicked: { Job_Mgr.buttonActivateJob() }
                }
            }

        Rectangle {
            id: saveJobButton
            width: buttonWidth
            height: buttonHeight
            
            anchors.verticalCenter: parent.verticalCenter
            visible: false // TODO : define this button
            
            color: mouse_Area_Save_Job.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
            
			
            Image { // The icon metaphor
                id: saveJobMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 28
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_job_save.png"
                }

            Text {
                id: saveJobTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobSave
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Save_Job
                anchors.fill: parent
                onClicked: {
                    console.log("[Qml] Opening Mini-explorer for Save Button" );
                }
            }
        }

        Rectangle {
            id: createSummaryButton
            width: buttonWidth
            height: buttonHeight
            color: mouse_Area_Summary.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
            anchors.verticalCenter: parent.verticalCenter
            opacity: ( ijmIsDisplayed ) ? 0 : 1

            Image { // The icon metaphor
                id: summaryMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 24
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_job_summary_report.png"
                }

            Text {
                id: summaryTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobSaveReport
                font.bold: true
                font.pointSize: 10
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Summary
                anchors.fill: parent
                onClicked: { Job_Mgr.buttonCreateSummaryReport(); }
                }
            }

        Rectangle {
            id: stratasyncButton
            width: buttonWidth
            height: buttonHeight
            color: mouse_Area_StrataSync.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
            anchors.verticalCenter: parent.verticalCenter
            opacity: ( ijmIsDisplayed ) ? 0 : 1

            Image { // The icon metaphor
                id: stratasyncMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 28
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_job_stratasync.png"
                }

            Text {
                id: stratasyncTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobSynsStrataSync
                font.bold: true
                font.pointSize: 10
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_StrataSync
                anchors.fill: parent
                onClicked: { Job_Mgr.buttonStrataSync(); }
                }
            }

        Rectangle {
            id: exitButton
            width: buttonWidth
            height: buttonHeight
            color: mouse_Area_Exit.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
            anchors.verticalCenter: parent.verticalCenter

            Image { // The icon metaphor
                id: exitMetaphor
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 2
                anchors.horizontalCenter: parent.horizontalCenter
                height: 28
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_job_exit.png"
                }

            Text {
                id: exitTitle
                anchors.top: parent.top
                anchors.topMargin: 4
                anchors.fill: parent
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobExit
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }

            MouseArea {
                id: mouse_Area_Exit
                anchors.fill: parent
                onClicked: { 
                    saveContentPos();
                    Job_Mgr.close_Job_Gui(); 
                    }
                }
            }

        //Rectangle {
        //    id: toggleIjmButton
        //    width: buttonWidth
        //    height: buttonHeight
        //
        //    anchors.verticalCenter: parent.verticalCenter
        //    visible: true // For temporary IJM debugging
        //
        //    color: ijmIsDisplayed ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
        //
        //    Image { // The icon metaphor
        //        id: toggleIjmMetaphor
        //        anchors.bottom: parent.bottom
        //        anchors.bottomMargin: 2
        //        anchors.horizontalCenter: parent.horizontalCenter
        //        height: 28
        //        fillMode: Image.PreserveAspectFit
        //        source:"/acterna/storage/look-and-feel/generic/icon_job_ijm_dvt.png"
        //        }
        //
        //    Text {
        //        id: toggleIjmTitle
        //        anchors.top: parent.top
        //        anchors.topMargin: 4
        //        anchors.fill: parent
        //        color: VColor.cViaviColorWhite
        //        text: "IJM"
        //        font.bold: true
        //        font.pointSize: 11
        //        horizontalAlignment: Text.AlignHCenter
        //        }
        //
        //    MouseArea {
        //        id: mouse_Area_toggleIjm
        //        anchors.fill: parent
        //        onClicked: {
        //            console.log("[Qml] Toggle IJM Button" );
        //            if (!loaderIjm.active)
        //                {
        //                loaderIjm.active = true
        //                console.log("[Qml] Activating IJM" );
        //                }
        //            else
        //                {
        //                if (backgroundJobMgr.ijmLoader.opened)
        //                    {
        //                    backgroundJobMgr.ijmLoader.close()
        //                    console.log("[Qml] Closing IJM" );
        //                    }
        //                else
        //                    {
        //                    backgroundJobMgr.ijmLoader.open()
        //                    console.log("[Qml] Opening IJM" );
        //                    }
        //                }
        //            }
        //        }
        //    }

        } //end of Row

    Popup {
        id : ijmJobManager
        anchors.centerIn: parent
        width: backgroundJobMgr.width
        height: backgroundJobMgr.height
        closePolicy: Popup.NoAutoClose
        modal: false
        focus: true
        visible: ( ijmIsDisplayed ) ? 1 : 0
        opacity: ( ijmIsDisplayed ) ? 1 : 0

        DefaultLayout { // Imported from IJM GUI
            id: defaultLayout
            anchors.fill:parent
            clip:true
            showHeader: false
            showNewButton: true
            showMoreOptions: false
            keyboardHeightScale: 0.5

            onSyncRequested: { // signal from IJM GUI
                console.log("[Qml] Sync button was pressed" );
                Job_Mgr.buttonStrataSync(); // Use same slot as Legacy Job Mgr for now
            }

            onCreateReportClicked: { // signal from IJM GUI
                console.log("[Qml] Create Report button was pressed" );
                Job_Mgr.buttonCreateSummaryReport(job.jobNumber);  // Use same slot as Legacy Job Mgr for now
            }

            jobPropertyDisplayNames: ({  // Allows us to provide translations we already have available
                "customerName": jobManagerTranslation.txtIjmCustomer, 
                "jobNumber": jobManagerTranslation.txtIjmJobId,
                "techId": jobManagerTranslation.txtIjmTechId,
                "contractorId": jobManagerTranslation.txtIjmContractorId
                // (and possibly...) jobManagerTranslation.txtIjmComments // mComments
                //                   jobManagerTranslation.txtIjmFiberId  // mFiber_Id
                })

            preferredTestProperties: ["configuration"] // Use the configuration column to display refInfo correctly // Exclude ,"location"]
            preferredTestPropertiesAlwaysVisible: 1    // Just one column is enough
            testPropertyDisplayNames: ({
                "configuration": jobManagerTranslation.txtIjmConfColumnTitle, 
                "location": jobManagerTranslation.txtIjmLocColumnTitle,
                "fiberId": jobManagerTranslation.txtIjmFiberId  // TODO Allow this to be used 
                })

            fileDialogFolders: ([ // Used for pop-up dialogs when importing label lists into IJM ISW-2423
                {
                "name": "disk",
                "path": "/user/disk",
                "icon": "/acterna/storage/look-and-feel/generic/harddrive.png"
                },
                {
                "name": "usb",
                "path": "/user/usbflash",
                "icon": "/acterna/storage/look-and-feel/generic/usbflash.png"
                }
            ])

            // Rectangle { // Temporary way back to Legacy GUI for debugging: Remove before FCS
            //     id: invisibleIjmToggle
            //     width: 10
            //     height: 10
            //     anchors.top: parent.top
            //     anchors.left : parent.left
            //     color: "transparent"
            //     MouseArea {
            //         id: mouse_Area_InvisibleIjmToggle
            //         anchors.fill: parent
            //         onClicked: {
            //             console.log("[Qml] Found it! - Turning off IJM" );
            //             if (loaderIjm.active && backgroundJobMgr.ijmLoader.opened)
            //                 {
            //                 backgroundJobMgr.ijmLoader.close()
            //                 console.log("[Qml] Closing IJM" );
            //                 }
            //         }
            //     }
            // }
        }
    }
    
    Flickable {
        id: theWholeJob
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: isu_Job_Mgr_Buttons_Row.bottom
        anchors.topMargin: 4
        anchors.bottom: parent.bottom

        opacity: ( ijmIsDisplayed ) ? 0 : 1
        
        contentHeight: jobInfoHeader.height + jobInfoPanel.height + jobInfoPanel.anchors.topMargin + testPlanHeader.height + testPlanPanel.height + testPlanPanel.anchors.topMargin + testReportsHeader.height + testReportsPanel.height + testReportsPanel.anchors.topMargin
        contentWidth: backgroundJobMgr.width
        
        interactive: contentHeight > height
        clip:true
        flickableDirection: Flickable.VerticalFlick
        boundsBehavior: Flickable.StopAtBounds
        
        enabled: !keyboard.visible && !jobSkipTest.visible && !continuityCheckItem.visible && !manualStepItem.visible && !popupLoadJobJson.visible

        //------------------------------------------------------

        Rectangle {
            id: jobInfoHeader
            
            width: jobInfoTitle.width + jobInfoIcon.width
            height: jobInfoTitle.height + (jobInfoTitle.anchors.topMargin * 2)
            
            anchors.left: parent.left
            anchors.leftMargin: marginHeaderWidth
            anchors.top: parent.top // isu_Job_Mgr_Buttons_Row.bottom
            color: mouse_Area_Job_Info.containsMouse ? VColor.cViaviColorLightBlue : "transparent"
            opacity: ( mouse_Area_Job_Info.containsMouse ) ? 0.5 : 1

            Text {
                id: jobInfoTitle
                anchors.top: parent.top
                anchors.topMargin : 3
                color: VColor.cViaviColorWhite
                font.family: "DejaVu LGC Sans"
                text: jobManagerTranslation.txtJobInformation
                font.bold: true
                font.pointSize: 12
                }
            Image {
                id: jobInfoIcon
                height: 16
                width: 16
                fillMode: Image.PreserveAspectFit
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: jobInfoTitle.right
                anchors.leftMargin: 3
                source: isJobInfoPanelOn ? "/acterna/storage/look-and-feel/generic/icon_collapse_down.png" : "/acterna/storage/look-and-feel/generic/icon_collapse_right.png"
                }
            MouseArea {
                id: mouse_Area_Job_Info
                anchors.fill: parent
                onClicked: {
                    isJobInfoPanelOn = !isJobInfoPanelOn ;
                    console.log("[Qml] jobInfoHeader clicked");
                    }
                }
            }

        Isu_Job_Info_Panel {
            id: jobInfoPanel      
            
            jobInfoEditableState: Job_Mgr.job_Mgr_State === 0 // Future intention is to be able to lock/protect whether or not Job Info fields can be modified.
                                                              // (in addition to current criteria limiting editing when a Job is active).                                                
        }

        //------------------------------------------------------

        Rectangle {
            id: testPlanHeader
            
            width: testPlanTitle.width + testPlanIcon.width
            height: testPlanTitle.height + (testPlanTitle.anchors.topMargin * 2)
            
            anchors.top: jobInfoPanel.bottom
            anchors.left: parent.left
            anchors.leftMargin: marginHeaderWidth
            
            color: mouse_Area_Test_Plan_Title.containsMouse ? VColor.cViaviColorLightBlue : "transparent"
            opacity: ( mouse_Area_Test_Plan_Title.containsMouse ) ? 0.5 : 1

            Text {
                id: testPlanTitle
                anchors.top: parent.top
                anchors.topMargin: 3
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobTestPlan
                font.bold: true
                font.pointSize: 12
                horizontalAlignment: Text.AlignHCenter
                }
            Image {
                id: testPlanIcon
                height: 16
                width: 16
                fillMode: Image.PreserveAspectFit
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: testPlanTitle.right
                anchors.leftMargin: 3
                source: isJobTestPlanPanelOn ? "/acterna/storage/look-and-feel/generic/icon_collapse_down.png" : "/acterna/storage/look-and-feel/generic/icon_collapse_right.png"
                }

            MouseArea {
                id: mouse_Area_Test_Plan_Title
                anchors.fill: parent
                onClicked: {
                    isJobTestPlanPanelOn = !isJobTestPlanPanelOn ;
                    console.log("[Qml] testPlanHeader clicked");
                    }
                }
            }


        Isu_Job_Test_Plan_Panel {
            id: testPlanPanel
            
//            isEditable: Job_Mgr.job_Mgr_State === 1 // Future intention is to be able to lock/protect whether or not Job Info fields can be modified.
//                                                    // (in addition to current criteria limiting editing when a Job is active).
            isEditable: true // TBD Probably don't want to condition Launch & Skip buttons to whether or not the Job is active (5800v2 doesn't)
            }

        //------------------------------------------------------

        Rectangle {
            id: testReportsHeader
            
            width: testReportsTitle.width + testReportsIcon.width
            height: testReportsTitle.height + (testReportsTitle.anchors.topMargin * 2)
            
            anchors.top: testPlanPanel.bottom
            anchors.left: parent.left
            anchors.leftMargin: marginHeaderWidth
            
            color: mouse_Area_Test_Reports_Header.containsMouse ? VColor.cViaviColorLightBlue : "transparent"
            opacity: ( mouse_Area_Test_Reports_Header.containsMouse ) ? 0.5 : 1

            Text {
                id: testReportsTitle
                anchors.top: parent.top
                anchors.topMargin: 3
                color: VColor.cViaviColorWhite
                text: jobManagerTranslation.txtJobTestReport
                font.bold: true
                font.pointSize: 12
                horizontalAlignment: Text.AlignHCenter
                }
            Image {
                id: testReportsIcon
                height: 16
                width: 16
                fillMode: Image.PreserveAspectFit
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: testReportsTitle.right
                anchors.leftMargin: 3
                source: isJobTestReportsPanelOn ? "/acterna/storage/look-and-feel/generic/icon_collapse_down.png" : "/acterna/storage/look-and-feel/generic/icon_collapse_right.png"
                }
            MouseArea {
                id: mouse_Area_Test_Reports_Header
                anchors.fill: parent
                onClicked: {
                    isJobTestReportsPanelOn = !isJobTestReportsPanelOn ;
                    }
                }
            }
            
        // *TEST* FILTER (Final filtering TBD)
        Row {
            anchors.left: testReportsPanel.left // == testReportsName.right //testReportsHeader.right
            anchors.leftMargin: 180 //20
            anchors.verticalCenter: testReportsHeader.verticalCenter
            spacing: 10
           
            // All
            Rectangle {
                width: 100
                height: 20
                color: mouse_Area_Test_Filter_1.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple

                Text {
                    anchors.centerIn: parent
                    color: VColor.cViaviColorWhite
                    text: "All"
                    font.bold: true
                    font.pointSize: 12
                    horizontalAlignment: Text.AlignHCenter
                }
              
                MouseArea {
                    id: mouse_Area_Test_Filter_1
                    anchors.fill: parent
                    onClicked: {
                        filterTestReports( ReportModelFilter.C_No_Filter );                        
                    }
                }
            }
           
            // SOR
            Rectangle {
                width: 100
                height: 20
                color: mouse_Area_Test_Filter_2.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple

                Text {
                    anchors.centerIn: parent
                    color: VColor.cViaviColorWhite
                    text: "SOR"
                    font.bold: true
                    font.pointSize: 12
                    horizontalAlignment: Text.AlignHCenter
                }
              
                MouseArea {
                    id: mouse_Area_Test_Filter_2
                    anchors.fill: parent
                    onClicked: {
                        filterTestReports( ReportModelFilter.C_SOR );                        
                    }
                }
            }
           
            // JSON
            Rectangle {
                width: 100
                height: 20
                color: mouse_Area_Test_Filter_3.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple

                Text {
                    anchors.centerIn: parent
                    color: VColor.cViaviColorWhite
                    text: "JSON"
                    font.bold: true
                    font.pointSize: 12
                    horizontalAlignment: Text.AlignHCenter
                }
              
                MouseArea {
                    id: mouse_Area_Test_Filter_3
                    anchors.fill: parent
                    onClicked: {
                        filterTestReports( ReportModelFilter.C_JSON );                        
                    }
                }
            }
           
            // PDF
            Rectangle {
                width: 100
                height: 20
                color: mouse_Area_Test_Filter_4.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple

                Text {
                    anchors.centerIn: parent
                    color: VColor.cViaviColorWhite
                    text: "PDF"
                    font.bold: true
                    font.pointSize: 12
                    horizontalAlignment: Text.AlignHCenter
                }

                MouseArea {
                    id: mouse_Area_Test_Filter_4
                    anchors.fill: parent
                    onClicked: {
                        filterTestReports( ReportModelFilter.C_PDF );                        
                    }
                }
            }
        }

        Isu_Job_Test_Reports_Panel {
            id: testReportsPanel
            } // end testReportsPanel

        //------------------------------------------------------

        } // end Flickable theWholeJob
        
    Isu_Continuity_Check_Item {
      id: continuityCheckItem
      
      visible: Job_Mgr.continuityManager.displayContinuityCheck

      width: backgroundJobMgr.width
      anchors.bottom: backgroundJobMgr.bottom
      
      inputHeadertext: jobManagerTranslation.txtJobContinuityCheck
      inputCommentTextHeader: jobManagerTranslation.txtJobAdditionnalComment
      inputModel: Job_Mgr.continuityManager.alarmModel
      
      onVisibleChanged: {
      	if ( visible == true )
	      	{
	      	outputComment = "";
	      	indexAlarm = -1;
	      	}
      }
      
      function close( validation )
         {
         Job_Mgr.continuityManager.displayContinuityCheck = false;
         
         if ( validation != false ) 
	         {
	         Job_Mgr.continuityManager.Continuity_Check_Validation( indexAlarm, outputComment );
	         }
         }
   }
   
   Isu_Manual_Step_Item {
        id: manualStepItem
        visible: Job_Mgr.manualStepManager.displayManualStep

        width: backgroundJobMgr.width
        anchors.bottom: backgroundJobMgr.bottom

        inputHeadertext: Job_Mgr.manualStepManager.header
        inputAutoHeadertext: jobManagerTranslation.txtJobAutoComment
      	inputPersonnalHeaderText: jobManagerTranslation.txtJobAdditionnalComment
        inputModel: Job_Mgr.manualStepManager.alarmModel

        onVisibleChanged: {
            if ( visible == true )
               {
               indexAlarm = -1;
               autoComment = "";
               personnalComment = "";
               indexTestPlan = -1;
               currentCode = -1;
               bDisplayList = false;
               }
            }

        function close( validation )
            {
            Job_Mgr.manualStepManager.displayManualStep = false;

            if ( validation != false )
                {
                if(isPredefinedComment() === true)
                   {
                   Job_Mgr.manualStepManager.Manual_Step_Validation( indexAlarm, autoComment + ": " + personnalComment );
                   }
                else
                   {
                   Job_Mgr.manualStepManager.Manual_Step_Validation( indexAlarm, personnalComment );
                   }
                }
            }
   }
        
    Key_Board {
        id: keyboard
        visible: false
        anchors.fill: parent
        anchors.centerIn: parent
        displayCursor: true
    }
    
    Mini_File_Explorer {
        id: miniFileExplorer
        visible: false
        anchors.fill: parent
        anchors.centerIn: parent
        
        inputModel: Job_Mgr.miniFileExplorer.fileModel
        inputDirectoryPath: Job_Mgr.miniFileExplorer.directoryPath
        
        onBtnLoadClick: {
            console.log("[Qml] Loading", filePath );
            resetSavedPos();
        	jobErrorShown = !Job_Mgr.buttonLoadJob( filePath );
        }
    }
    
   Isu_Job_Skip_Test {
      id: jobSkipTest
      
      visible: false

      width: backgroundJobMgr.width
      anchors.bottom: backgroundJobMgr.bottom
      
      inputHeadertext: jobManagerTranslation.txtJobSkipReason
      inputAutoHeadertext: jobManagerTranslation.txtJobAutoComment
      inputPersonnalHeaderText: jobManagerTranslation.txtJobAdditionnalComment
   }

    Pop_Up_Warning {
    	id: popUpWarningActivation
    	
    	warningType: "Info"
    	property int currentIndex: -1

    	visible: false
		
		numberOfButtons: 2
		
		function closePopUp() {
			popUpWarningActivation.visible = false
		}
		
				
		function launch() {
			Job_Mgr.testPlanModel.launch_Test( popUpWarningActivation.currentIndex );
			popUpWarningActivation.visible = false;
		}
		
		onVisibleChanged: {
			if ( popUpWarningActivation.visible )
				{
				popUpWarningActivation.warningText = jobManagerTranslation.txtJobWarningActivation;
				popUpWarningActivation.warningSubText = "";
				popUpWarningActivation.btnRText = jobManagerTranslation.txtJobGoBack;
				popUpWarningActivation.btnRClicked.connect(closePopUp);
				popUpWarningActivation.btnLText = jobManagerTranslation.txtJobLaunchAnyway;
				popUpWarningActivation.btnLClicked.connect(launch);
				}
			else
				{
				currentIndex = -1;
				popUpWarningActivation.warningText = "";
				popUpWarningActivation.warningSubText = "";
				popUpWarningActivation.btnRClicked.disconnect(closePopUp);			
				popUpWarningActivation.btnLClicked.disconnect(launch);			
				}
		}
		
		anchors.centerIn: parent
    }
    
    Rectangle {
        id: popupLoadJobJson;
        
        implicitWidth: 500;
        implicitHeight: 150;
        
        visible: jobErrorShown;
        
        anchors {
        	right: parent.right;
        	rightMargin: marginWidth;
        	verticalCenter: parent.verticalCenter;
    	}
        
        
      	color: popUpMousearea.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorLightGray2

        border {
        	color: "black";
        	width: 1;
        }
        
        Row {
        	id: rowLoadJob
       
	        anchors {
	        	fill: popupLoadJobJson;
	        	leftMargin: 15;
	       	}
	        
	        spacing: 25;
	                 
            Image { // The icon metaphor
                id: loadJobPopUp

                anchors.verticalCenter: rowLoadJob.verticalCenter
                
                height: 64
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Warning.png"
            }

	        Text {
	        	id: popUpTextField;
	        	anchors.verticalCenter: rowLoadJob.verticalCenter; 
        	
	            text: jobManagerTranslation.txtJobLoadError;
	            font.bold: true;
	            font.pointSize: 11;
	        }
	        
	        // TODO Add buttons
	        
        }

        
        MouseArea {
        	id: popUpMousearea
        	anchors.fill: parent
        	onClicked: {
	              jobErrorShown = false;
          	}
        }        
    }
} // end Rectangle

