import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: container

    width: 600
    height: 250

    color: VColor.cViaviColorLightGray2
    
    border.color: VColor.cViaviColorGray
    border.width: 4
    
    property int standardHeight: 40

    property int indexTestPlan: -1
    property int containerTextSize: 12
    
    property string inputHeadertext: ""
    property string inputLowerText: ""
    property string inputCommentTextHeader: ""
    property alias inputModel: repeaterItem.model
    
    property string outputComment: ""
    property int indexAlarm: -1
    
    function close( validation ) {
    }
    
    Text {
      id: textHeader
      
      anchors.left: container.left
      anchors.leftMargin: 10
      anchors.top: container.top
      anchors.topMargin: 10
      
      text: container.inputHeadertext
      
      font.bold: true
      font.pointSize: 16
      font.family: "DejaVu LGC Sans"
    }
    
    Column {
    	anchors.top: textHeader.bottom
    	anchors.topMargin: 5
    	
    	anchors.bottom: buttonSelection.top
    	anchors.bottomMargin: 5
    	
    	anchors.left: container.left
    	anchors.leftMargin: 20
    	
    	spacing: 5
    	
		Repeater {
			id: repeaterItem
		    
		    Rectangle {
		        width: 150
		        height: standardHeight
		        color: "transparent"
		        
		        Rectangle {
		            id: checkIcon
		        	anchors.left: parent.left
		        	anchors.verticalCenter: parent.verticalCenter
		        	
		        	width: parent.height - 6
		        	height: width
		        	
		        	radius: width * 0.5
		        	
		        	color: indexAlarm == index ? VColor.cViaviColorLogoPurple : "transparent"
		        	border.color: VColor.cViaviColorLogoPurple
		        	border.width: 4
		        }
		        
		        Text {
		        	anchors.left: checkIcon.right
		        	anchors.leftMargin: 10
		        	anchors.verticalCenter: parent.verticalCenter
		        	text: modelData
		        	font.pixelSize: 16
		        }
		        
		        MouseArea {
		        	anchors.fill: parent
		        	onClicked: {
		        		container.indexAlarm = index;
		        	}
		        }
		    }
		}
    }
    
    Text {
      anchors.left: commentContainer.left
      anchors.bottom: commentContainer.top
      anchors.bottomMargin: 5
      
      text: container.inputCommentTextHeader
      
      font.italic: true
      font.pointSize: 12
      font.family: "DejaVu LGC Sans"
    }
    
    Rectangle {
      id: commentContainer
      
      anchors.right: container.right
      anchors.rightMargin: 10
      anchors.top: textHeader.bottom
      anchors.topMargin: 20
      
      
      height: container.standardHeight
      width: container.width * 0.5
      
      clip: true
      
      function editText(txtOutput, validation) {   
         if (validation === true)
            {
            container.outputComment = txtOutput;
            }
            
            keyboard.editText.disconnect( commentContainer.editText );   
      }
      
      Text {
          anchors.left: parent.left
          anchors.leftMargin: 3
          anchors.verticalCenter: parent.verticalCenter
          
          text: container.outputComment
          font.family: "DejaVu LGC Sans"
          font.pointSize: containerTextSize
      }
      
      MouseArea {
         anchors.fill: parent
         
         onClicked: {
            keyboard.editText.connect( commentContainer.editText );
            openKeyBoard( container.inputCommentTextHeader, container.outputComment );
         }
      }
    }
    
    Rectangle {
       id: buttonSelection
       
       height: 50 //container.standardHeight * 1.5
       
       property int buttonWidth: buttonSelection.height * 1.5
       property int buttonHeight: buttonSelection.height
       property int buttonMargin: 10

       color: VColor.cViaviColorLightGray2
       
       anchors.bottom: container.bottom
       anchors.left: container.left
       anchors.right: container.right
       
       Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: rowButtons.left
         anchors.rightMargin: 2

         color: VColor.cViaviColorGray
       
         Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: container.inputLowerText
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pointSize: 16
            wrapMode: Text.NoWrap
            
            clip: true
         }
       }

       Row {
         id: rowButtons
         spacing: 2
         
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.right: parent.right
         
         layoutDirection: Qt.RightToLeft
   
         Rectangle {
               id:validbutton
         
               color: VColor.cViaviColorGray
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
               
               opacity: indexAlarm !== (-1) ? 1 : 0.6
         
               Image {
                   id: imgValidButton
                   fillMode: Image.PreserveAspectFit
                   
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Ok.png"
               }
         
         
               MouseArea {
                   id: mouseAreaValidButton
                   anchors.fill: parent
                   
                   enabled: indexAlarm !== (-1)
                   
                   onClicked: {
                     container.close( true );
                   }
               }
         
               states: State {
                   name: "pressed"
                   when: mouseAreaValidButton.pressed
                   PropertyChanges {
                       target: validbutton
                       color: VColor.cViaviColorLightBlue
                   }
               }
         }
   
         Rectangle {
               id:cancelbutton
   
               color: VColor.cViaviColorGray
   
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
   
               Image {
                   id: imgCancelButton
                   
                   fillMode: Image.PreserveAspectFit
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Clear.png"
               }
   
               MouseArea {
                   id: mouseAreaCancelButton
                   anchors.fill: parent
                   
                   onClicked: {
                     container.close( false );
                   }
               }
   
               states: State {
                   name: "pressed"
                   when: mouseAreaCancelButton.pressed
                   PropertyChanges {
                       target: cancelbutton
                       color: VColor.cViaviColorLightBlue
                   }
               }
         }
       }
    }
}

