import QtQuick 2.7
import QtQuick.Controls 2.0

import "ViaviStyle"

Item{
    id: root
    width: gradient.width + ticksColumn.width

    property double colorIntensity
    property int nrOfTicks: 5
    property double minValue: 0
    property double maxValue: 100
    property int labelNrOfDecimals: 0

    Rectangle {
        id: gradient
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: parent.left

        width: ViaviStyle.layouts.imageButtonHeight

        gradient: Gradient {
            GradientStop { position: 0.0; color: Qt.rgba( colorIntensity,            0.0,            0.0, 1.0) }
            GradientStop { position: 0.25; color: Qt.rgba(colorIntensity, colorIntensity,            0.0, 1.0) }
            GradientStop { position: 0.5; color: Qt.rgba(            0.0, colorIntensity,            0.0, 1.0) }
            GradientStop { position: 0.75; color: Qt.rgba(           0.0, colorIntensity, colorIntensity, 1.0) }
            GradientStop { position: 1; color: Qt.rgba(              0.0,              0, colorIntensity, 1.0) }
        }
    }

    Item{
        id: ticksColumn
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: gradient.right

        width: childrenRect.width

        Repeater{
            model: nrOfTicks

            Row{
                y: model.index / (root.nrOfTicks - 1) * (ticksColumn.height - ViaviStyle.layouts.borderSize)

                spacing: ViaviStyle.layouts.largeMargin

                Rectangle{
                    id: tickLine
                    height: ViaviStyle.layouts.borderSize
                    width: ViaviStyle.layouts.largeMargin

                    color: ViaviStyle.colors.borderColor
                }

                Text{
                    anchors.verticalCenter: tickLine.verticalCenter
                    font: ViaviStyle.layouts.largeBoldFont
                    verticalAlignment: Text.AlignVCenter
                    width: contentWidth

                    text: (maxValue - (maxValue - minValue) *  model.index / (root.nrOfTicks - 1)).toFixed(labelNrOfDecimals)
                }

            }
        }
    }


}
