import QtQuick 2.3
import QtQuick.Layouts 1.2

import "./GenericTableUtils.js" as TableUtils

import "ViaviStyle"

Rectangle{
    id: container
    // color: ViaviStyle.colors.borderColor
    color: ViaviStyle.colors.contentBackgroundColor
    clip: true

    property int gridWidth: width
    property int cellHeight: ViaviStyle.layouts.genericTableLineHeight
    property int headerHeight: ViaviStyle.layouts.genericTableHeaderHeight
    property font headerFont: ViaviStyle.layouts.headerFont

    Component{
        id: cellItemComponent

        GenericTableCell {
            isHeader: true
            isIcon: modelCellIcon !== ""
            cellWidth: modelCellWidth
            height: headerHeight
            textColor: ViaviStyle.colors.getTextColor( modelCellStatus )
            textDisplay: isIcon ? modelCellIcon : modelCellText
            textAlignment: modelCellAllignment
            cellFont: headerFont
        }
    }


    Column{
        Repeater{
            model: generictable_res_tableHeaderList.value

            Item{
                id: delegateId

                property var listModel: model

                width: rowId.width
                height: rowId.height

                Row{
                    id: rowId

                    spacing: 0

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_0.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_0.value
                        property int modelCellStatus: listModel.elementStatus0
                        property string modelCellIcon: listModel.elementIcon0
                        property string modelCellText: listModel.elementText0
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_1.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_1.value
                        property int modelCellStatus: listModel.elementStatus1
                        property string modelCellIcon: listModel.elementIcon1
                        property string modelCellText: listModel.elementText1
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_2.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_2.value
                        property int modelCellStatus: listModel.elementStatus2
                        property string modelCellIcon: listModel.elementIcon2
                        property string modelCellText: listModel.elementText2
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_3.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_3.value
                        property int modelCellStatus: listModel.elementStatus3
                        property string modelCellIcon: listModel.elementIcon3
                        property string modelCellText: listModel.elementText3
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_4.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_4.value
                        property int modelCellStatus: listModel.elementStatus4
                        property string modelCellIcon: listModel.elementIcon4
                        property string modelCellText: listModel.elementText4
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_5.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_5.value
                        property int modelCellStatus: listModel.elementStatus5
                        property string modelCellIcon: listModel.elementIcon5
                        property string modelCellText: listModel.elementText5
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_6.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_6.value
                        property int modelCellStatus: listModel.elementStatus6
                        property string modelCellIcon: listModel.elementIcon6
                        property string modelCellText: listModel.elementText6
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_7.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_7.value
                        property int modelCellStatus: listModel.elementStatus7
                        property string modelCellIcon: listModel.elementIcon7
                        property string modelCellText: listModel.elementText7
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_8.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_8.value
                        property int modelCellStatus: listModel.elementStatus8
                        property string modelCellIcon: listModel.elementIcon8
                        property string modelCellText: listModel.elementText8
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_9.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_9.value
                        property int modelCellStatus: listModel.elementStatus9
                        property string modelCellIcon: listModel.elementIcon9
                        property string modelCellText: listModel.elementText9
                    }


                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_10.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_10.value
                        property int modelCellStatus: listModel.elementStatus10
                        property string modelCellIcon: listModel.elementIcon10
                        property string modelCellText: listModel.elementText10
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_11.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_11.value
                        property int modelCellStatus: listModel.elementStatus11
                        property string modelCellIcon: listModel.elementIcon11
                        property string modelCellText: listModel.elementText11
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_headerColWidth_12.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_headerColAlignment_12.value
                        property int modelCellStatus: listModel.elementStatus12
                        property string modelCellIcon: listModel.elementIcon12
                        property string modelCellText: listModel.elementText12
                    }

                }
            }
        }
    }
}

