import QtQuick 2.3
import QtQuick.Layouts 1.1
import "ViaviStyle"

Rectangle{
    id: functionsTabsContainer

    height: ViaviStyle.layouts.isSmallScreen ?
                ViaviStyle.layouts.buttonHeight / 2 : ViaviStyle.layouts.buttonHeight

    color: ViaviStyle.colors.contentBackgroundColor

    function translateIconTypeToPath(type){
        switch(type){
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Default:
                return ViaviStyle.images.tabsIconsBasePath + "fn_default.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Otdr:
                return ViaviStyle.images.tabsIconsBasePath + "fn_otdr.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Osa:
                return ViaviStyle.images.tabsIconsBasePath + "fn_osa.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pmd:
                return ViaviStyle.images.tabsIconsBasePath + "fn_pmd.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pwrmtr:
                return ViaviStyle.images.tabsIconsBasePath + "fn_pwrmtr.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Switch:
                return ViaviStyle.images.tabsIconsBasePath + "fn_switch.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Fix:
                return ViaviStyle.images.tabsIconsBasePath + "fn_fix.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Ovp:
                return ViaviStyle.images.tabsIconsBasePath + "fn_ovp.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Oeo:
                return ViaviStyle.images.tabsIconsBasePath + "fn_oeo.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Ats:
                return ViaviStyle.images.tabsIconsBasePath + "fn_ats.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Orl:
                return ViaviStyle.images.tabsIconsBasePath + "fn_orl.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Bbs:
                return ViaviStyle.images.tabsIconsBasePath + "fn_bbs.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Odm:
                return ViaviStyle.images.tabsIconsBasePath + "fn_odm.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Pib:
                return ViaviStyle.images.tabsIconsBasePath + "fn_pib.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Jfk:
                return ViaviStyle.images.tabsIconsBasePath + "fn_jfk.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Dts:
                return ViaviStyle.images.tabsIconsBasePath + "fn_dts.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Fn_Dtss:
                return ViaviStyle.images.tabsIconsBasePath + "fn_dtss.png";
            case functionsTabs_res_functionIconEnum.enums.ecIcon_Unknown:
                return "";
        }
        return "";
    }

    ListView{
        id: listViewId
        anchors.fill: parent

        orientation: ListView.Horizontal
        boundsBehavior: Flickable.OvershootBounds

        model: functionsTabs_res_functions.value

        readonly property int maxNrOfVisibleItems: 6
        property int cellWidth: width / maxNrOfVisibleItems

        delegate: Item{
            id: rootDelegate

            readonly property real scaleFactor: ViaviStyle.layouts.isSmallScreen ? 1.4 : 2

            width: Math.max(listViewId.cellWidth, laser.width + functionImage.width + functionText.width + ViaviStyle.layouts.largeMargin)
            height: functionsTabsContainer.height
            clip: true

            Rectangle{
                id: backgroundRectangle
                anchors.fill: parent

                color: mouseAreaId.pressed
                       ?  ViaviStyle.colors.selectedColor
                       : (model.index === functionsTabs_cfg_currentFunction.value)
                                        ? ViaviStyle.colors.activeColor : "transparent"

                border.color: ViaviStyle.colors.borderColor
            }

            Row{
                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.left: parent.left

                anchors.margins: ViaviStyle.layouts.smallMargin

                spacing: ViaviStyle.layouts.smallMargin

                Item{
                    id: laser

                    width: rootDelegate.height / 4
                    height: width
                    anchors.verticalCenter: parent.verticalCenter

                    Rectangle{
                        anchors.fill: parent

                        radius: width / 2

                        color: measurementRunning ? ViaviStyle.colors.passColor : "transparent"
                        border.color: ViaviStyle.colors.separatorColor

                        visible: model.functionRunning || model.measurementRunning
                    }
                }


                Image {
                    id: functionImage
                    anchors.verticalCenter: parent.verticalCenter

                    height: functionText.contentHeight
                    width: height * rootDelegate.scaleFactor

                    source: translateIconTypeToPath(model.icon)
                }

                Text{
                    id: functionText
                    verticalAlignment: Text.AlignVCenter
                    anchors.verticalCenter: parent.verticalCenter

                    text: model.name
                    font: ViaviStyle.layouts.activeTextFont
                    color: (mouseAreaId.pressed
                            || model.index === functionsTabs_cfg_currentFunction.value )
                                ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
                }
            }

            MouseArea{
                id: mouseAreaId

                anchors.fill: parent

                onClicked: {
                    functionsTabs_cfg_currentFunction.value = model.index
                }
            }

        }
    }
}
