import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2
import elf_plugin 1.0
import "ViaviStyle"

AbstractButton {
    id: button

    property alias textHorizontalAlignment: text.horizontalAlignment
    property alias textAnchors: text.anchors
    property string iconPath: ''
    property alias radius: rectangle.radius

    property ElfData elfAction

    readonly property real opacityEnabled: 1
    readonly property real opacityDisabled: 0.5
    opacity: enabled ? opacityEnabled : opacityDisabled

    implicitWidth: ViaviStyle.layouts.buttonHeight * 5
    implicitHeight: ViaviStyle.layouts.buttonHeight

    contentItem:
    Rectangle {
        id: rectangle
        color: button.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
        anchors.fill: parent

        Rectangle {
            anchors.centerIn: parent
            width: icon.visible ? icon.width + text.width : text.width
            Image {
                id: icon
                visible: iconPath.length > 0
                width: visible ? contentItem.height : 0
                height: contentItem.height
                anchors.verticalCenter: parent.verticalCenter
                fillMode: Image.PreserveAspectFit
                source: iconPath
                mipmap: true
            }

            Text {
                id: text

                anchors.verticalCenter: parent.verticalCenter
                anchors.left:icon.right
                anchors.leftMargin: ViaviStyle.layouts.smallMargin
                width: contentWidth
                text: button.text
                font: ViaviStyle.layouts.activeBoldTextFont
                color: ViaviStyle.colors.activeItemTextColor
            }
        }
    }

    onClicked:{
        if(elfAction){
            elfAction.invoke()
        }
    }
}
